/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.datagen.loot.modifiers;

import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DAFishingLootModifier
extends LootModifier {
    public static final Supplier<Codec<DAFishingLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DAFishingLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)WeightedEntry.Wrapper.m_146305_((Codec)ItemStack.f_41582_).listOf().fieldOf("items").forGetter(m -> m.items)).and((App)Codec.INT.fieldOf("totalWeight").forGetter(m -> m.totalWeight)).and((App)Codec.FLOAT.fieldOf("chanceToSpawn").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, DAFishingLootModifier::new)));
    public final List<WeightedEntry.Wrapper<ItemStack>> items;
    public final int totalWeight;
    public final float chance;

    public DAFishingLootModifier(LootItemCondition[] conditionsIn, List<WeightedEntry.Wrapper<ItemStack>> items, int totalWeight, float chance) {
        super(conditionsIn);
        this.items = items.stream().map(wrapper -> WeightedEntry.m_146290_((Object)((ItemStack)wrapper.m_146310_()).m_41777_(), (int)wrapper.m_142631_().m_146281_())).toList();
        this.totalWeight = totalWeight;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_78952_().m_46472_() == AetherDimensions.AETHER_LEVEL && context.m_230907_().m_188501_() > this.chance) {
            int itemNum = context.m_230907_().m_188503_(this.totalWeight);
            int num = 0;
            ItemStack modifiedStack = null;
            for (WeightedEntry.Wrapper<ItemStack> stack : this.items) {
                if ((num += stack.m_142631_().m_146281_()) < itemNum) continue;
                modifiedStack = (ItemStack)stack.m_146310_();
                break;
            }
            if (modifiedStack != null) {
                generatedLoot.set(0, modifiedStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

