/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.block.behavior;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.fluids.DAFluidTypes;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAItems;

@Mod.EventBusSubscriber(modid="deep_aether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DABlockInteractionBehavior {
    @SubscribeEvent
    public static void bonemealEvent(BonemealEvent event) {
        if (event.getBlock().m_204336_(DATags.Blocks.HAS_GLOWING_SPORES)) {
            Block.m_49840_((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            event.getStack().m_41774_(1);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack = event.getItemStack();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        if (itemstack.m_204117_(Tags.Items.SHEARS)) {
            DABlockInteractionBehavior.handleShears(event, itemstack, pos, level, state, player);
        } else if (event.getFace() != Direction.DOWN && PotionUtils.m_43579_((ItemStack)itemstack) == Potions.f_43599_) {
            DABlockInteractionBehavior.handleWatterBottle(event, itemstack, pos, level, state, player);
        } else if (itemstack.m_41720_() == AetherItems.SKYROOT_POISON_BUCKET.get()) {
            DABlockInteractionBehavior.handleSkyrootPoisonBucket(event, itemstack, level, player);
        } else if (itemstack.m_41720_() == AetherItems.SKYROOT_BUCKET.get()) {
            DABlockInteractionBehavior.handleSkyrootBucket(event, itemstack, level, player);
        }
    }

    private static void handleShears(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, BlockPos pos, Level level, BlockState state, Player player) {
        if (state.m_60734_().equals(DABlocks.GLOWING_VINE.get())) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)PipeBlock.f_55152_, (Comparable)((Boolean)state.m_61143_((Property)PipeBlock.f_55152_)))).m_61124_((Property)PipeBlock.f_55148_, (Comparable)((Boolean)state.m_61143_((Property)PipeBlock.f_55148_)))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)((Boolean)state.m_61143_((Property)PipeBlock.f_55149_)))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)((Boolean)state.m_61143_((Property)PipeBlock.f_55150_)))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)((Boolean)state.m_61143_((Property)PipeBlock.f_55151_))), 18);
            level.m_5594_(player, pos, SoundEvents.f_12075_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.m_5776_()) {
                itemstack.m_41622_(1, (LivingEntity)player, item -> {});
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        } else if (state.m_60734_().equals(DABlocks.TALL_GLOWING_GRASS.get()) && ((DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.UPPER)) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)DABlocks.GLOWING_SPORES.get()));
            level.m_7731_(pos.m_6625_(1), (BlockState)Blocks.f_50359_.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER), 18);
            level.m_7731_(pos, (BlockState)Blocks.f_50359_.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 18);
            level.m_5594_(player, pos, SoundEvents.f_11697_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.m_5776_()) {
                itemstack.m_41622_(1, (LivingEntity)player, item -> {});
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        }
    }

    private static void handleWatterBottle(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, BlockPos pos, Level level, BlockState state, Player player) {
        if (state.m_60734_() == AetherBlocks.AETHER_DIRT.get()) {
            BlockState newState = ((Block)DABlocks.AETHER_MUD.get()).m_49966_();
            level.m_46597_(pos, newState);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
                ItemStack bottleStack = new ItemStack((ItemLike)Items.f_42590_);
                if (!player.m_36356_(bottleStack)) {
                    Containers.m_18992_((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)bottleStack);
                }
            }
            if (!level.f_46443_) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            level.m_5594_(player, pos, SoundEvents.f_11769_, SoundSource.PLAYERS, 0.5f, 1.0f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static void handleSkyrootPoisonBucket(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, Level level, Player player) {
        BlockHitResult blockRayTraceResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockState blockHitState = level.m_8055_(blockRayTraceResult.m_82425_());
        if (blockRayTraceResult.m_6662_() == HitResult.Type.MISS || blockRayTraceResult.m_6662_() != HitResult.Type.BLOCK || blockHitState.m_60734_() == Blocks.f_50256_ || !player.m_6144_() && blockHitState.m_155947_() && level.m_7702_(blockRayTraceResult.m_82425_()) instanceof MenuProvider) {
            event.setCancellationResult(InteractionResult.PASS);
        } else {
            BlockPos blockpos = blockRayTraceResult.m_82425_();
            Direction direction = blockRayTraceResult.m_82434_();
            BlockPos relativePos = blockpos.m_121945_(direction);
            if (level.m_7966_(player, blockpos) && player.m_36204_(relativePos, direction, itemstack)) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, relativePos, itemstack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    ItemStack bucketStack = new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get());
                    if (!player.m_36356_(bucketStack)) {
                        Containers.m_18992_((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)bucketStack);
                    }
                }
                level.m_46597_(relativePos, ((LiquidBlock)DABlocks.POISON_BLOCK.get()).m_49966_());
                level.m_5594_(null, relativePos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private static void handleSkyrootBucket(PlayerInteractEvent.RightClickBlock event, ItemStack itemstack, Level level, Player player) {
        BlockHitResult blockhitresult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult.m_6662_() == HitResult.Type.MISS || level.m_8055_(blockhitresult.m_82425_()).m_60734_() == Blocks.f_50016_ || level.m_8055_(blockhitresult.m_82425_()).m_60734_() == DABlocks.POISON_CAULDRON.get()) {
            event.setCancellationResult(InteractionResult.PASS);
        } else {
            BlockPos blockpos = blockhitresult.m_82425_();
            Direction direction = blockhitresult.m_82434_();
            BlockPos relativePos = blockpos.m_121945_(direction);
            Item item = null;
            if (level.m_6425_(relativePos).getFluidType() == DAFluidTypes.POISON_FLUID_TYPE.get()) {
                item = (Item)AetherItems.SKYROOT_POISON_BUCKET.get();
            } else if (level.m_8055_(blockpos).m_60713_((Block)DABlocks.VIRULENT_QUICKSAND.get())) {
                item = (Item)DAItems.SKYROOT_VIRULENT_QUICKSAND_BUCKET.get();
                relativePos = blockpos;
            }
            System.out.println(item);
            if (item != null) {
                DABlockInteractionBehavior.skyrootBucketInteractionResult(event, level, relativePos, player, itemstack, item);
            }
        }
    }

    private static void skyrootBucketInteractionResult(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos relativePos, Player player, ItemStack itemstack, Item item) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
            ItemStack bucketStack = new ItemStack((ItemLike)item);
            if (!player.m_36356_(bucketStack)) {
                Containers.m_18992_((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)bucketStack);
            }
        }
        level.m_46597_(relativePos, Blocks.f_50016_.m_49966_());
        level.m_5594_(null, relativePos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }
}

