/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.google.common.reflect.Reflection;
import com.legacy.lost_aether.registry.LCEntityTypes;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import teamrazor.aeroblender.aether.AetherRuleCategory;
import teamrazor.deepaether.DeepAetherConfig;
import teamrazor.deepaether.advancement.DAAdvancementTriggers;
import teamrazor.deepaether.block.behavior.DADispenseBehaviors;
import teamrazor.deepaether.block.behavior.DaCauldronInteraction;
import teamrazor.deepaether.datagen.DABlockstateData;
import teamrazor.deepaether.datagen.DAItemModelData;
import teamrazor.deepaether.datagen.DARecipeData;
import teamrazor.deepaether.datagen.loot.DALootTableData;
import teamrazor.deepaether.datagen.loot.modifiers.DAGlobalLootModifiers;
import teamrazor.deepaether.datagen.loot.modifiers.DALootDataProvider;
import teamrazor.deepaether.datagen.tags.DABiomeTagData;
import teamrazor.deepaether.datagen.tags.DABlockTagData;
import teamrazor.deepaether.datagen.tags.DAEntityTagData;
import teamrazor.deepaether.datagen.tags.DAFluidTagData;
import teamrazor.deepaether.datagen.tags.DAItemTagData;
import teamrazor.deepaether.datagen.tags.DASoundTagData;
import teamrazor.deepaether.datagen.world.DAWorldGenData;
import teamrazor.deepaether.event.DAGeneralEvents;
import teamrazor.deepaether.fluids.DAFluidTypes;
import teamrazor.deepaether.init.DABlockEntityTypes;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAEnchantments;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DAFluids;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.init.DAMenuTypes;
import teamrazor.deepaether.init.DAMobEffects;
import teamrazor.deepaether.init.DAParticles;
import teamrazor.deepaether.init.DAPotions;
import teamrazor.deepaether.init.DASounds;
import teamrazor.deepaether.networking.DAPacketHandler;
import teamrazor.deepaether.recipe.DARecipeBookTypes;
import teamrazor.deepaether.recipe.DARecipeSerializers;
import teamrazor.deepaether.recipe.DARecipeTypes;
import teamrazor.deepaether.util.BetterBrewingRecipe;
import teamrazor.deepaether.world.biomes.DARareRegion;
import teamrazor.deepaether.world.biomes.DARegion;
import teamrazor.deepaether.world.biomes.DASurfaceData;
import teamrazor.deepaether.world.feature.DAFeatures;
import teamrazor.deepaether.world.feature.tree.decorators.DADecoratorType;
import teamrazor.deepaether.world.feature.tree.decorators.DARootPlacers;
import teamrazor.deepaether.world.feature.tree.foliage.DAFoliagePlacers;
import teamrazor.deepaether.world.feature.tree.trunk.DaTrunkPlacerTypes;
import teamrazor.deepaether.world.placementmodifier.DAPlacementModifiers;
import teamrazor.deepaether.world.structure.DAStructurePieceTypes;
import teamrazor.deepaether.world.structure.DAStructureProcessor;
import teamrazor.deepaether.world.structure.DAStructureTypes;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="deep_aether")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DeepAether {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "deep_aether";
    public static final String LOST_AETHER_CONTENT = "lost_aether_content";
    public static final String AETHER_GENESIS = "aether_genesis";
    public static final String AETHER_REDUX = "aether_redux";
    public static final String ANCIENT_AETHER = "ancient_aether";
    public static final String EMISSIVITY = "aether_emissivity";
    public static final String PROTECT_YOUR_MOA = "aether_protect_your_moa";
    public static final String TREASURE_REFORGING = "aether_treasure_reforging";
    private static final String PROTOCOL_VERSION = "1";
    public static final Path DIRECTORY = FMLPaths.CONFIGDIR.get().resolve("deep_aether");
    private static final Calendar CALENDER = Calendar.getInstance();
    public static final boolean IS_HALLOWEEN = CALENDER.get(2) == 9 && CALENDER.get(5) > 20 || CALENDER.get(2) == 10 && CALENDER.get(5) < 10;
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("deep_aether", "deep_aether"), () -> "1", "1"::equals, "1"::equals);

    public static boolean IsHalloweenContentEnabled() {
        return IS_HALLOWEEN || (Boolean)DeepAetherConfig.COMMON.always_enable_halloween_content.get() != false;
    }

    public DeepAether() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::dataSetup);
        bus.addListener(this::commonSetup);
        DABlocks.BLOCKS.register(bus);
        DAItems.ITEMS.register(bus);
        DAParticles.PARTICLE_TYPES.register(bus);
        DAEntities.ENTITY_TYPES.register(bus);
        DASounds.SOUNDS.register(bus);
        DAFluids.FLUIDS.register(bus);
        DAFluidTypes.FLUID_TYPES.register(bus);
        DADecoratorType.REGISTRY.register(bus);
        DABlockEntityTypes.BLOCK_ENTITY_TYPES.register(bus);
        DABlocks.registerWoodTypes();
        DAFoliagePlacers.FOLIAGE_PLACERS.register(bus);
        DARootPlacers.ROOT_PLACERS.register(bus);
        DaTrunkPlacerTypes.TRUNK_PLACERS.register(bus);
        DAFeatures.FEATURES.register(bus);
        DAGlobalLootModifiers.LOOT_MODIFIERS.register(bus);
        DAMobEffects.EFFECTS.register(bus);
        DAPotions.POTIONS.register(bus);
        DARecipeTypes.RECIPE_TYPES.register(bus);
        DARecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        DAStructurePieceTypes.STRUCTURE_PIECE_TYPES.register(bus);
        DAStructureTypes.STRUCTURE_TYPES.register(bus);
        DAEnchantments.ENCHANTMENTS.register(bus);
        DAStructureProcessor.STRUCTURE_PROCESSOR_TYPES.register(bus);
        DAMenuTypes.MENUS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DeepAetherConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DeepAetherConfig.CLIENT_SPEC);
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new DABlockstateData(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DAItemModelData(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DAWorldGenData(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DARecipeData(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)DALootTableData.create(packOutput));
        DABlockTagData blockTags = new DABlockTagData(packOutput, lookupProvider, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new DAItemTagData(packOutput, lookupProvider, blockTags.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DABiomeTagData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DAFluidTagData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DAEntityTagData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DASoundTagData(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DALootDataProvider(packOutput));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        DAPacketHandler.register();
        Reflection.initialize((Class[])new Class[]{DAPlacementModifiers.class});
        Reflection.initialize((Class[])new Class[]{DARecipeBookTypes.class});
        DAAdvancementTriggers.init();
        event.enqueueWork(() -> {
            DaCauldronInteraction.bootStrap();
            DABlocks.registerPots();
            DABlocks.registerFlammability();
            DAItems.setupBucketReplacements();
            this.registerDispenserBehaviors();
            this.registerCompostable();
            this.registerFlawlessBossDrops();
        });
        event.enqueueWork(() -> {
            Regions.register((Region)new DARegion(DeepAether.getResource(MODID), (Integer)DeepAetherConfig.COMMON.deep_aether_biome_weight.get()));
            if (!((Boolean)DeepAetherConfig.COMMON.disable_storm_cloud_and_skyroot_rainforest_biomes.get()).booleanValue()) {
                Regions.register((Region)new DARareRegion(DeepAether.getResource("rare"), (Integer)DeepAetherConfig.COMMON.storm_cloud_biome_weight.get()));
            }
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)AetherRuleCategory.THE_AETHER, (String)MODID, (SurfaceRules.RuleSource)DASurfaceData.makeRules());
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.f_43599_, (Item)DAItems.BIO_CRYSTAL.get(), (Potion)DAPotions.REMEDY_POTION.get()));
        });
    }

    private void registerFlawlessBossDrops() {
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.SLIDER.get(), (String)DeepAetherConfig.COMMON.slider_flawless_boss_drop.get(), (Item)DAItems.SLIDER_EYE.get());
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.VALKYRIE_QUEEN.get(), (String)DeepAetherConfig.COMMON.valkyrie_queen_flawless_boss_drop.get(), (Item)DAItems.MEDAL_OF_HONOR.get());
        this.getFlawlessBossDrop((EntityType)AetherEntityTypes.SUN_SPIRIT.get(), (String)DeepAetherConfig.COMMON.sun_spirit_flawless_boss_drop.get(), (Item)DAItems.SUN_CORE.get());
        this.getFlawlessBossDrop((EntityType)DAEntities.EOTS_CONTROLLER.get(), (String)DeepAetherConfig.COMMON.eots_flawless_boss_drop.get(), (Item)DAItems.FLOATY_SCARF.get());
        if (ModList.get().isLoaded(LOST_AETHER_CONTENT)) {
            this.getFlawlessBossDrop(LCEntityTypes.AERWHALE_KING, (String)DeepAetherConfig.COMMON.aerwhale_king_flawless_boss_drop.get(), (Item)DAItems.AERWHALE_SADDLE.get());
        }
    }

    private void getFlawlessBossDrop(EntityType<?> type, String string, Item fallBack) {
        if (string.equals("null")) {
            DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, null);
        } else {
            String[] SliderItemId = string.split(":");
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(SliderItemId[0], SliderItemId[1]))) {
                DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(SliderItemId[0], SliderItemId[1])));
            } else {
                DAGeneralEvents.FLAWLESS_BOSS_DROP.put(type, fallBack);
                LOGGER.info("Config value " + string + " is referring to a missing item! Resolving to default value");
            }
        }
    }

    private void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)Items.f_42589_, (DispenseItemBehavior)DADispenseBehaviors.WATER_BOTTLE_TO_AETHER_MUD_DISPENSE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DAItems.PLACEABLE_POISON_BUCKET.get()), (DispenseItemBehavior)DADispenseBehaviors.DEEP_AETHER_BUCKET_PICKUP_DISPENSE_BEHAVIOR);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DAItems.VIRULENT_QUICKSAND_BUCKET.get()), (DispenseItemBehavior)DADispenseBehaviors.DEEP_AETHER_BUCKET_PICKUP_DISPENSE_BEHAVIOR);
    }

    public void registerCompostable() {
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.BLUE_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FLOWERING_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FLOWERING_BLUE_ROSEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CRUDEROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_MOSS_BLOCK.get()).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_MOSS_CARPET.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CLOUDBLOOM_CARPET.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ROSEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.BLUE_ROSEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CRUDEROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CONBERRY_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.CONBERRY_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_ROOTS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.YAGROOT_VINE.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.GLOWING_SPORES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SUNROOT_HANGER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AERGLOW_BLOSSOM_BLOCK.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.MINI_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SHORT_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_GOLDEN_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.RADIANT_ORCHID.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AERLAVENDER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_AERLAVENDER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.AETHER_CATTAILS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_AETHER_CATTAILS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.GOLDEN_FLOWER.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.SKY_TULIPS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.IASPOVE.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ENCHANTED_BLOSSOM.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.ECHAISY.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.LIGHTCAP_MUSHROOMS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.GOLDEN_ASPESS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.FEATHER_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)DABlocks.TALL_FEATHER_GRASS.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.AERGLOW_BLOSSOM.get()), 0.1f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.GOLDEN_BERRIES.get()), 0.2f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.GOLDEN_GRASS_SEEDS.get()), 0.1f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.SQUASH_SEEDS.get()), 0.1f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DAItems.CLOUDBLOOM_BOUQUET.get()), 0.1f);
    }

    @SubscribeEvent
    public static void addAetherAdditionalResourcesPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            DeepAether.setupCompatPack("client/deep_aether_additional_assets", "Deep Aether Additional Assets", event, PackType.CLIENT_RESOURCES, PackSource.f_10528_, false);
            DeepAether.setupCompatPack("client/deep_aether_tooltips", "Deep Aether Ability Tooltips", event, PackType.CLIENT_RESOURCES, PackSource.f_10528_, false);
            if (ModList.get().isLoaded(EMISSIVITY)) {
                DeepAether.setupCompatPack("client/deep_aether_emissivity", "Deep Aether Emissivity", event, PackType.CLIENT_RESOURCES, PackSource.f_10528_, true);
            }
            if (ModList.get().isLoaded(AETHER_GENESIS) || ModList.get().isLoaded(AETHER_REDUX)) {
                DeepAether.setupCompatPack("client/golden_swet_ball/DAGoldenSwetBallFixClient", "Deep Aether Golden Swet Ball Texture Fix", event, PackType.CLIENT_RESOURCES, PackSource.f_10527_, true);
            }
        }
        if (event.getPackType() == PackType.SERVER_DATA) {
            if (ModList.get().isLoaded(PROTECT_YOUR_MOA)) {
                DeepAether.setupCompatPack("server/protect_your_moa_compat", "Deep Aether Protect Your Moa Compat", event);
            }
            if (ModList.get().isLoaded(AETHER_GENESIS)) {
                DeepAether.setupCompatPack("client/golden_swet_ball/DAGoldenSwetBallAetherGenesisFixData", "Deep Aether Golden Swet Ball Aether Genesis Fix", event);
            } else if (ModList.get().isLoaded(AETHER_REDUX)) {
                DeepAether.setupCompatPack("client/golden_swet_ball/DAGoldenSwetBallAetherReduxFixData", "Deep Aether Golden Swet Ball Aether Redux Fix", event);
            }
            if (ModList.get().isLoaded(LOST_AETHER_CONTENT)) {
                DeepAether.setupCompatPack("server/aether_lost_content_compat", "Lost Aether Content Compat", event);
            } else {
                DeepAether.setupCompatPack("server/aether_lost_content_not_compat", "Deep Aether Aerwhale Saddle Recipe", event);
            }
            if (ModList.get().isLoaded(AETHER_REDUX)) {
                DeepAether.setupCompatPack("server/aether_redux_compat", "Aether Redux Compat", event);
            }
            if (ModList.get().isLoaded(ANCIENT_AETHER)) {
                DeepAether.setupCompatPack("server/ancient_aether_compat", "Ancient Aether Compat", event);
            }
        }
    }

    private static void setupCompatPack(String location, String name, AddPackFindersEvent event) {
        DeepAether.setupCompatPack(location, name, event, PackType.SERVER_DATA, PackSource.f_10530_, true);
    }

    private static void setupCompatPack(String location, String name, AddPackFindersEvent event, PackType type, PackSource source, boolean force) {
        Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/" + location});
        Pack pack = Pack.m_245429_((String)("builtin/" + location), (Component)Component.m_237113_((String)name), (boolean)force, path -> new PathPackResources(path, resourcePath, true), (PackType)type, (Pack.Position)Pack.Position.TOP, (PackSource)source);
        event.addRepositorySource(consumer -> consumer.accept(pack));
    }

    public static ResourceLocation getResource(String resourceName) {
        return new ResourceLocation(MODID, resourceName);
    }
}

