/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.trees;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.systems.nodemapper.DestroyerNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.SpeciesNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.StateNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.MushroomBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomFamily;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.zepalesque.redux.block.ReduxBlocks;
import org.jetbrains.annotations.NotNull;

public class DropLogsMushroomFamily
extends HugeMushroomFamily {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(DropLogsMushroomFamily::new);

    public DropLogsMushroomFamily(ResourceLocation name) {
        super(name);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        MushroomBranchBlock branch = new MushroomBranchBlock(name, this.getProperties()){

            public LootTable.Builder createBranchDrops() {
                return DTLootTableProvider.BlockLoot.createBranchDrops((Block)((Block)this.getPrimitiveLog().get()), (Item)this.getFamily().getStick(1).m_41720_());
            }

            public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
                BlockState blockState = level.m_8055_(cutPos);
                SpeciesNode speciesNode = new SpeciesNode();
                MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(new NodeInspector[]{speciesNode}));
                Species species = speciesNode.getSpecies();
                StateNode stateMapper = new StateNode(cutPos);
                this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new NodeInspector[]{stateMapper}));
                NetVolumeNode volumeSum = new NetVolumeNode();
                DestroyerNode destroyer = new DestroyerNode(species).setPlayer(entity instanceof Player ? (Player)entity : null);
                destroyMode = DynamicTrees.DestroyMode.HARVEST;
                this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new NodeInspector[]{volumeSum, destroyer}));
                destroyMode = DynamicTrees.DestroyMode.SLOPPY;
                List endPoints = destroyer.getEnds();
                HashMap<BlockPos, BlockState> destroyedLeaves = new HashMap<BlockPos, BlockState>();
                ArrayList<BranchBlock.ItemStackPos> leavesDropsList = new ArrayList<BranchBlock.ItemStackPos>();
                this.destroyMushroomCap(level, cutPos, species, entity == null ? ItemStack.f_41583_ : entity.m_21205_(), endPoints, destroyedLeaves, leavesDropsList, (Entity)entity);
                endPoints = endPoints.stream().map(p -> p.m_121996_((Vec3i)cutPos)).collect(Collectors.toList());
                int trunkHeight = 1;
                BlockPos iter = new BlockPos(0, 1, 0);
                while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
                    ++trunkHeight;
                    iter = iter.m_7494_();
                }
                Direction cutDir = signal.localRootDir;
                if (cutDir == null) {
                    cutDir = Direction.DOWN;
                }
                return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
            }

            public void destroyMushroomCap(@NotNull Level level, @NotNull BlockPos cutPos, @NotNull Species species, @NotNull ItemStack tool, @NotNull List<BlockPos> endPoints, @NotNull Map<BlockPos, BlockState> destroyedCapBlocks, @NotNull List<BranchBlock.ItemStackPos> drops, Entity entity) {
                if (!(species instanceof HugeMushroomSpecies)) {
                    return;
                }
                HugeMushroomSpecies mushSpecies = (HugeMushroomSpecies)species;
                Family family = species.getFamily();
                if (!(family instanceof HugeMushroomFamily)) {
                    return;
                }
                HugeMushroomFamily family2 = (HugeMushroomFamily)family;
                if (level.f_46443_ || endPoints.isEmpty()) {
                    return;
                }
                BlockBounds bounds = this.getFamily().expandLeavesBlockBounds(new BlockBounds(endPoints));
                SimpleVoxmap capMap = new SimpleVoxmap(bounds);
                for (BlockPos endPos : endPoints) {
                    int age = DynamicCapCenterBlock.getCapAge((Level)level, (BlockPos)endPos.m_7494_());
                    if (age >= 0) {
                        for (BlockPos findPos : mushSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext((LevelAccessor)level, endPos.m_7494_(), mushSpecies, Integer.valueOf(age)))) {
                            BlockState findState = level.m_8055_(findPos);
                            if (!family2.isCompatibleCap(mushSpecies, findState, level, findPos)) continue;
                            capMap.setVoxel(findPos.m_123341_(), findPos.m_123342_(), findPos.m_123343_(), (byte)1);
                        }
                        capMap.setVoxel(endPos, (byte)0);
                    }
                    for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
                        BlockPos pos = endPos.m_121955_(surr.getOffset());
                        BlockState state = level.m_8055_(pos);
                        if (!level.m_8055_(pos).m_60713_((Block)ReduxBlocks.CLOUDCAP_SPORES.get())) continue;
                        if (entity instanceof Player) {
                            BlockEntity te = level.m_7702_(pos);
                            state.m_60734_().onDestroyedByPlayer(state, level, pos, (Player)entity, true, level.m_6425_(pos));
                            state.m_60734_().m_6240_(level, (Player)entity, pos, state, te, tool);
                            continue;
                        }
                        level.m_7731_(pos, BlockStates.AIR, 0);
                    }
                }
                ArrayList dropList = new ArrayList();
                for (SimpleVoxmap.Cell cell : capMap.getAllNonZeroCells()) {
                    BlockPos.MutableBlockPos pos = cell.getPos();
                    BlockState state = level.m_8055_((BlockPos)pos);
                    if (!family2.isCompatibleCap(mushSpecies, state, level, (BlockPos)pos)) continue;
                    dropList.clear();
                    CapProperties cap = this.getCapProperties(state);
                    dropList.addAll(cap.getDrops(level, (BlockPos)pos, tool, species));
                    BlockPos imPos = pos.m_7949_();
                    BlockPos relPos = imPos.m_121996_((Vec3i)cutPos);
                    level.m_7731_(imPos, BlockStates.AIR, 3);
                    destroyedCapBlocks.put(relPos, state);
                    dropList.forEach(i -> drops.add(new BranchBlock.ItemStackPos(i, relPos)));
                }
            }

            private CapProperties getCapProperties(BlockState state) {
                if (state.m_60734_() instanceof DynamicCapBlock) {
                    return Optional.of((DynamicCapBlock)state.m_60734_()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL);
                }
                return state.m_60734_() instanceof DynamicCapCenterBlock ? Optional.of((DynamicCapCenterBlock)state.m_60734_()).map(block -> block.getProperties(state)).orElse(CapProperties.NULL) : CapProperties.NULL;
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

