/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.MangroveRootsLogic;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class YagrootRootsLogic
extends MangroveRootsLogic {
    public static final ConfigurationProperty<Integer> HORIZONTAL_PROBABILITY = ConfigurationProperty.integer((String)"horizontal_probability");

    public YagrootRootsLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HORIZONTAL_PROBABILITY, (Object)8);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HORIZONTAL_PROBABILITY});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.m_122424_();
        Direction defaultDir = context.signal().defaultDir;
        BlockPos downPos = context.pos().m_121955_(defaultDir.m_122436_());
        boolean isOverGround = context.level().m_8055_(downPos).m_60783_((BlockGetter)context.level(), downPos, defaultDir.m_122424_());
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            if (dir.m_122434_().m_122479_()) {
                int n = probMap[dir.m_122411_()] = isOverGround ? (Integer)configuration.get(HORIZONTAL_PROBABILITY) : 0;
            }
            if (dir.equals((Object)defaultDir)) {
                probMap[dir.m_122411_()] = 1;
            }
            if (dir.equals((Object)defaultDir.m_122424_())) {
                probMap[dir.m_122411_()] = 0;
            }
            BlockPos deltaPos = context.pos().m_121945_(dir);
            BlockState deltaBlockState = context.level().m_8055_(deltaPos);
            int n = dir.m_122411_();
            probMap[n] = probMap[n] + TreeHelper.getTreePart((BlockState)deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        if (context.signal().isInTrunk()) {
            probMap[defaultDir.ordinal()] = 0;
        }
        probMap[defaultDir.m_122424_().ordinal()] = 0;
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

