/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BlightwillowLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Float> HORIZONTAL_SPREAD = ConfigurationProperty.floatProperty((String)"horizontal_spread");

    public BlightwillowLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HORIZONTAL_SPREAD, (Object)Float.valueOf(5.0f));
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HORIZONTAL_SPREAD});
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        boolean turningAway;
        Direction newDir = super.selectNewDirection(configuration, context);
        BlockPos d = context.signal().delta;
        boolean turningOutOfX = d.m_123343_() == 0 && d.m_123341_() != 0 && newDir.m_122434_() == Direction.Axis.Z;
        boolean turningOutOfZ = d.m_123341_() == 0 && d.m_123343_() != 0 && newDir.m_122434_() == Direction.Axis.X;
        boolean bl = turningAway = !context.signal().isInTrunk() && newDir.m_122434_() != Direction.Axis.Y && context.signal().energy % 2.0f == 0.0f;
        if (turningOutOfX || turningOutOfZ || turningAway) {
            context.signal().energy = Math.min(context.signal().energy, 1.0f);
        }
        return newDir;
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Direction fromDir = context.signal().dir.m_122424_();
        if (context.signal().isInTrunk()) {
            probMap[Direction.UP.ordinal()] = 0;
        } else {
            double sideChance = context.signal().energy % 2.0f == 0.0f ? 1.0 : 8.0;
            double upChance = context.signal().energy % 2.0f == 0.0f ? 16.0 : 1.0;
            for (Direction dir : Direction.values()) {
                if (dir.m_122434_() != Direction.Axis.Y) {
                    float dot = context.signal().delta.m_123341_() * dir.m_122436_().m_123341_() + context.signal().delta.m_123343_() * dir.m_122436_().m_123343_();
                    int n = probMap[dir.ordinal()] = dot < 0.0f ? 0 : (int)sideChance;
                }
                if (dir.equals((Object)fromDir) || probMap[dir.ordinal()] == 0) continue;
                BlockPos deltaPos = context.pos().m_121945_(dir);
                BlockState deltaBlockState = context.level().m_8055_(deltaPos);
                int n = dir.m_122411_();
                probMap[n] = probMap[n] + TreeHelper.getTreePart((BlockState)deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
            }
            probMap[Direction.UP.ordinal()] = (int)upChance;
        }
        probMap[Direction.DOWN.ordinal()] = 0;
        probMap[fromDir.ordinal()] = 0;
        return probMap;
    }
}

