/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import maxhyper.dtaether.compat.CompatHandler;
import maxhyper.dtaether.genfeatures.PetalsGenFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeafPileGenFeature
extends PetalsGenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> MAX_DEPTH = ConfigurationProperty.integer((String)"max_depth");
    public static final ConfigurationProperty<Integer> RADIUS = ConfigurationProperty.integer((String)"radius");
    public static final ConfigurationProperty<Integer> MAX_LAYERS = ConfigurationProperty.integer((String)"max_leaf_layers");

    public LeafPileGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, MAX_DEPTH, RADIUS, PLACE_CHANCE, MAX_COUNT, MAX_LAYERS});
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(MAX_DEPTH, (Object)15)).with(RADIUS, (Object)1)).with(PLACE_CHANCE, (Object)Float.valueOf(0.02f))).with(MAX_COUNT, (Object)10)).with(MAX_LAYERS, (Object)4);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.f_50016_) {
            return false;
        }
        BlockState state = ((Block)configuration.get(BLOCK)).m_49966_();
        return state.m_61138_((Property)this.layersProperty());
    }

    private IntegerProperty layersProperty() {
        return CompatHandler.blockStateProperties.getLeafPileLayersProperty();
    }

    @Override
    protected boolean canBePlacedOnBlock(LevelAccessor level, BlockPos pos, Block block) {
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_204336_(BlockTags.f_215833_)) {
            return false;
        }
        if (blockstate.m_204336_(BlockTags.f_215834_)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)level, pos), (Direction)Direction.UP) || blockstate.m_60713_(block) && (Integer)blockstate.m_61143_((Property)this.layersProperty()) == 16;
    }

    @Override
    protected BlockState getPetalsForPlacement(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos, BlockState state) {
        return (BlockState)state.m_61124_((Property)this.layersProperty(), (Comparable)Integer.valueOf(1 + level.m_213780_().m_188503_(((Integer)configuration.get(MAX_LAYERS)).intValue())));
    }
}

