/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;

public class HolidayDecorationGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> GIFT_CHANCE = ConfigurationProperty.floatProperty((String)"gift_chance");
    public static final ConfigurationProperty<Integer> MAX_DEPTH = ConfigurationProperty.integer((String)"max_depth");
    public static final ConfigurationProperty<Integer> SNOW_RADIUS = ConfigurationProperty.integer((String)"snow_radius");

    public HolidayDecorationGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(GIFT_CHANCE, (Object)Float.valueOf(0.1f))).with(MAX_DEPTH, (Object)4)).with(SNOW_RADIUS, (Object)2);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{GIFT_CHANCE, MAX_DEPTH, SNOW_RADIUS});
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        int tipHeight = 0;
        BlockPos.MutableBlockPos tipPos = context.pos().m_6630_(tipHeight).m_122032_();
        for (int i = 0; i < 32; ++i) {
            tipPos.m_122184_(0, 1, 0);
            BlockState testState = context.level().m_8055_((BlockPos)tipPos);
            if (TreeHelper.isBranch((BlockState)testState) || TreeHelper.isLeaves((BlockState)testState)) continue;
            tipHeight = i;
            break;
        }
        if (tipHeight <= 1) {
            return false;
        }
        this.placeCircle(configuration, context.level(), context.random(), (BlockPos)tipPos, tipHeight, context.radius());
        return true;
    }

    private void placeCircle(GenFeatureConfiguration configuration, LevelAccessor level, RandomSource random, BlockPos pos, int tipHeight, int treeRadius) {
        this.placeBlockAt(configuration, level, random, pos, 0.0f, tipHeight);
        int radius = treeRadius + (Integer)configuration.get(SNOW_RADIUS);
        for (int z = 1; z < radius; ++z) {
            for (int x = 0; x < radius; ++x) {
                if (Mth.m_144944_((int)x) + Mth.m_144944_((int)z) > Mth.m_144944_((int)radius)) continue;
                float distance = (float)Math.sqrt(Mth.m_144944_((int)x) + Mth.m_144944_((int)z)) / (float)Mth.m_144944_((int)radius);
                this.placeBlockAt(configuration, level, random, pos.m_7918_(x, 0, z), distance, tipHeight);
                this.placeBlockAt(configuration, level, random, pos.m_7918_(-x, 0, -z), distance, tipHeight);
                this.placeBlockAt(configuration, level, random, pos.m_7918_(-z, 0, x), distance, tipHeight);
                this.placeBlockAt(configuration, level, random, pos.m_7918_(z, 0, -x), distance, tipHeight);
            }
        }
    }

    private void placeBlockAt(GenFeatureConfiguration configuration, LevelAccessor level, RandomSource random, BlockPos pos, float distance, int tipHeight) {
        for (int i = 0; i >= -(tipHeight + (Integer)configuration.get(MAX_DEPTH)); --i) {
            BlockPos blockPos = pos.m_6630_(i);
            if (!level.m_46859_(blockPos.m_7494_()) || !level.m_7433_(blockPos, HolidayDecorationGenFeature::isAetherGrass) && !level.m_7433_(blockPos, HolidayDecorationGenFeature::isLeaves) && !Feature.m_65788_((LevelSimulatedReader)level, (BlockPos)blockPos) || !level.m_46859_(blockPos.m_6630_(4)) || !(distance <= random.m_188501_() / 2.0f * (1.0f - distance))) continue;
            if (level.m_7433_(blockPos, HolidayDecorationGenFeature::isLeaves)) {
                level.m_7731_(blockPos.m_7494_(), Blocks.f_50125_.m_49966_(), 3);
                break;
            }
            level.m_7731_(blockPos.m_7494_(), HolidayDecorationGenFeature.getSnowOrGift(random, ((Float)configuration.get(GIFT_CHANCE)).floatValue()), 3);
            break;
        }
    }

    private static BlockState getSnowOrGift(RandomSource random, float chance) {
        return random.m_188501_() < chance ? ((Block)AetherBlocks.PRESENT.get()).m_49966_() : Blocks.f_50125_.m_49966_();
    }

    private static boolean isAetherGrass(BlockState state) {
        return state.m_204336_(AetherTags.Blocks.AETHER_DIRT);
    }

    private static boolean isLeaves(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_);
    }
}

