/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.cancellers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class AetherTreeFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> treeFeatureConfigClass;

    public AetherTreeFeatureCanceller(ResourceLocation registryName, Class<T> treeFeatureConfigClass) {
        super(registryName);
        this.treeFeatureConfigClass = treeFeatureConfigClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        FeatureConfiguration featureConfig = configuredFeature.f_65378_();
        if (featureConfig instanceof RandomFeatureConfiguration) {
            RandomFeatureConfiguration RFC = (RandomFeatureConfiguration)featureConfig;
            return this.doesContainTrees(RFC, featureCancellations);
        }
        if (this.treeFeatureConfigClass.isInstance(featureConfig)) {
            String nameSpace = "";
            ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)configuredFeature.m_65398_().findFirst().get();
            FeatureConfiguration nextFeatureConfig = nextConfiguredFeature.f_65378_();
            ResourceLocation featureRegistryName = ForgeRegistries.FEATURES.getKey((Object)nextConfiguredFeature.f_65377_());
            if (featureRegistryName != null) {
                nameSpace = featureRegistryName.m_135827_();
            }
            if (this.treeFeatureConfigClass.isInstance(nextFeatureConfig) && !nameSpace.equals("") && featureCancellations.shouldCancelNamespace(nameSpace)) {
                return true;
            }
            if (nextFeatureConfig instanceof RandomFeatureConfiguration) {
                return this.doesContainTrees((RandomFeatureConfiguration)nextFeatureConfig, featureCancellations);
            }
        }
        return false;
    }

    private boolean doesContainTrees(RandomFeatureConfiguration featureConfig, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        for (WeightedPlacedFeature feature : featureConfig.f_67882_) {
            PlacedFeature currentPlacedFeature = (PlacedFeature)feature.f_191172_.m_203334_();
            ConfiguredFeature currentConfiguredFeature = (ConfiguredFeature)currentPlacedFeature.f_191775_().m_203334_();
            ResourceLocation featureRegistryName = ForgeRegistries.FEATURES.getKey((Object)((ConfiguredFeature)currentConfiguredFeature.m_65398_().findFirst().get()).f_65377_());
            if (this.treeFeatureConfigClass.isInstance(currentConfiguredFeature.f_65378_()) && featureRegistryName != null && featureCancellations.shouldCancelNamespace(featureRegistryName.m_135827_())) {
                return true;
            }
            FeatureConfiguration featureConfiguration = currentConfiguredFeature.f_65378_();
            if (!(featureConfiguration instanceof RandomFeatureConfiguration)) continue;
            RandomFeatureConfiguration RFC = (RandomFeatureConfiguration)featureConfiguration;
            return this.doesContainTrees(RFC, featureCancellations);
        }
        return false;
    }
}

