/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.blocks;

import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SnowyLeavesBlock
extends DynamicLeavesBlock {
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    private float leafChance = 0.66f;
    private int maxHydro = 1;

    public SnowyLeavesBlock(LeavesProperties leavesProperties, BlockBehaviour.Properties properties, float leafChance, int maxHydro) {
        super(leavesProperties, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
        this.leafChance = leafChance;
        this.maxHydro = maxHydro;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP ? (BlockState)state.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyLeavesBlock.isSnowySetting(facingState))) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState placementState = super.m_5573_(context);
        if (placementState.m_61138_((Property)SNOWY)) {
            BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
            return (BlockState)placementState.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(SnowyLeavesBlock.isSnowySetting(blockstate)));
        }
        return placementState;
    }

    private static boolean isSnowySetting(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SNOWY});
    }

    public int getHydrationLevelFromNeighbors(LevelAccessor level, BlockPos pos, LeavesProperties leavesProperties) {
        int hash;
        float rand;
        int hydro = super.getHydrationLevelFromNeighbors(level, pos, leavesProperties);
        if (hydro <= this.maxHydro && (rand = (float)(hash = CoordUtils.coordHashCode((BlockPos)pos, (int)2) % 1000) / 1000.0f) >= this.leafChance) {
            return 0;
        }
        return hydro;
    }

    public BlockState getLeavesBlockStateForPlacement(LevelAccessor level, BlockPos pos, BlockState leavesStateWithHydro, int oldHydro, boolean worldGen) {
        if (leavesStateWithHydro.m_61138_((Property)SNOWY)) {
            return (BlockState)leavesStateWithHydro.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false));
        }
        return leavesStateWithHydro;
    }
}

