/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.InvClientThings;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.ClientEvents;
import dlovin.inventoryhud.events.CuriosIntegration;
import dlovin.inventoryhud.events.UpdateNotificationEvent;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.OverlayRegister;
import dlovin.inventoryhud.gui.overlays.ArmorOverlay;
import dlovin.inventoryhud.gui.overlays.IHudOverlay;
import dlovin.inventoryhud.gui.overlays.InventoryOverlay;
import dlovin.inventoryhud.gui.overlays.PotionOverlay;
import dlovin.inventoryhud.keybinds.KeyBinds;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventoryhud")
public class InventoryHUD {
    public static InventoryHUD instance;
    public static final String modid = "inventoryhud";
    public static String version;
    private static final Logger logger;
    private static InvConfig CONFIG;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;
    public static boolean isCuriosMod;
    private InventoryGui inventoryGui;
    private List<IHudOverlay> overlays;

    public InventoryHUD() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        version = ((ModContainer)ModList.get().getModContainerByObject((Object)InventoryHUD.getInstance()).get()).getModInfo().getVersion().toString();
        CONFIG = new InvConfig();
        instance = this;
        CONFIG.register(ModLoadingContext.get());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (ModList.get().isLoaded("curios")) {
            isCuriosMod = true;
        }
        this.overlays = new ArrayList<IHudOverlay>();
        this.overlays.add(new InventoryOverlay("inventory"));
        this.overlays.add(new ArmorOverlay("armor"));
        this.overlays.add(new PotionOverlay("potion"));
        bus.register((Object)new KeyBinds());
        bus.register((Object)new OverlayRegister(this.overlays));
        bus.addListener(this::clientRegistries);
        InvClientThings.initClient();
    }

    public static InvConfig.Client getClientConfig() {
        return CONFIG.getClient();
    }

    public static void saveConfig() {
        InventoryHUD.CONFIG.clientSpec.save();
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryGui());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new UpdateNotificationEvent());
        if (isCuriosMod) {
            MinecraftForge.EVENT_BUS.register((Object)new CuriosIntegration());
        }
    }

    public void setInvGui(InventoryGui inventoryGui) {
        this.inventoryGui = inventoryGui;
        this.overlays.forEach(IHudOverlay::init);
    }

    public static void log(String message) {
        logger.info(message);
    }

    static {
        logger = LogManager.getLogger((String)modid);
        isActive = false;
        armorHUD = false;
        potionHUD = true;
        isCuriosMod = false;
    }
}

