/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.inventory.ChaosCrystalizerMenu;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileChaosCrystalizer
extends TileChaosHolderBase
implements IChangeListener,
IInteractTile,
MenuProvider {
    private int chargeRate = 10000;
    private ItemStack itemToMake = ((Item)DEContent.CHAOS_FRAG_SMALL.get()).m_7968_();
    public final ManagedInt charge = (ManagedInt)this.register((IManagedData)new ManagedInt("charge", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedInt chargeTo = (ManagedInt)this.register((IManagedData)new ManagedInt("chargeTo", 200, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));

    public TileChaosCrystalizer(BlockPos pos, BlockState state) {
        super((BlockEntityType)DAContent.tileChaosCrystalizer.get(), pos, state);
        this.itemHandler = new TileItemStackHandler((BlockEntity)this, 2);
        this.opStorage = new ModularOPStorage((TileBCore)this, 1000000L, 50000L, 50000L);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 1, (IOPStorage)this.opStorage, false);
        this.installIOTracker(this.opStorage);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        boolean valid = this.isTileEnabled() && (stack.m_41619_() || stack.m_41613_() < stack.m_41720_().getMaxStackSize(stack)) && this.chaos.get() >= TileChaosCrystalizer.calcChaos(this.itemToMake);
        this.active.set(valid);
        if (valid) {
            int finalCharge = this.calcCharge(this.itemToMake);
            if (finalCharge != this.chargeTo.get()) {
                this.chargeTo.set(finalCharge);
            }
            if (this.opStorage.getEnergyStored() >= this.chargeRate) {
                this.charge.add(1);
                this.opStorage.extractOP((long)this.chargeRate, false);
                if (this.charge.get() >= this.chargeTo.get()) {
                    this.discharge();
                    BCoreNetwork.sendSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)((SoundEvent)DESounds.BOOM.get()), (SoundSource)SoundSource.BLOCKS, (float)1.0f, (float)2.0f, (boolean)false);
                }
            } else if (this.charge.get() > 0) {
                this.charge.subtract(1);
            }
        } else if (this.charge.get() > 0) {
            this.charge.subtract(1);
        }
    }

    public void discharge() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        this.chaos.subtract(TileChaosCrystalizer.calcChaos(this.itemToMake));
        if (stack.m_41619_()) {
            stack = this.itemToMake.m_41777_();
        } else if (stack.m_41720_().equals(this.itemToMake.m_41720_())) {
            stack.m_41769_(1);
        }
        this.charge.set(0);
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 1 ? EnergyUtils.isEnergyItem((ItemStack)stack) : false;
    }

    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ChaosCrystalizerMenu(currentWindowIndex, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }
}

