/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.items;

import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.theurgy.TheurgyModule;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAAlchemicalSulfurItem
extends AlchemicalSulfurItem
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;

    public JAOPCAAlchemicalSulfurItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(new Item.Properties());
        this.form = form;
        this.material = material;
        this.tier = TheurgyModule.tierFunction.apply(material);
        this.type = switch (material.getType()) {
            case MaterialType.INGOT, MaterialType.INGOT_LEGACY -> AlchemicalSulfurType.METALS;
            case MaterialType.GEM, MaterialType.CRYSTAL -> AlchemicalSulfurType.GEMS;
            default -> AlchemicalSulfurType.OTHER_MINERALS;
        };
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void addToCreativeModeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("theurgy:sulfur.source.id", "#" + String.valueOf(MiscHelper.INSTANCE.getTagLocation(this.material.getType().getFormName(), this.material.getName())));
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41751_(nbt);
        output.m_246342_(stack);
    }

    public MutableComponent getSourceName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("%s", this.material, "%s").m_130948_(Style.f_131099_.m_178520_(this.tier.color()).m_131155_(Boolean.valueOf(true)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237110_((String)"item.jaopca.theurgy_alchemical_sulfurs.tooltip", (Object[])new Object[]{this.getSourceName(stack), ComponentUtils.m_130748_((Component)Component.m_237115_((String)this.tier.descriptionId()).m_130948_(Style.f_131099_.m_178520_(this.tier.color).m_131155_(Boolean.valueOf(true)))), ComponentUtils.m_130748_((Component)Component.m_237115_((String)this.type.descriptionId()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true))))}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)"item.jaopca.theurgy_alchemical_sulfurs", (Object[])new Object[]{ComponentUtils.m_130748_((Component)this.getSourceName(stack))});
    }
}

