/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.slurries;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.slurries.IMaterialFormSlurry;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryFormSettings;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCASlurry
extends Slurry
implements IMaterialFormSlurry {
    private final IForm form;
    private final IMaterial material;
    protected final ISlurryFormSettings settings;
    protected boolean isHidden;
    protected Supplier<TagKey<Item>> oreTag;

    public JAOPCASlurry(IForm form, IMaterial material, ISlurryFormSettings settings) {
        super(SlurryBuilder.builder((ResourceLocation)new ResourceLocation("jaopca", "slurry/" + material.getModelType() + "/" + form.getName())));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.isHidden = settings.getIsHidden();
        this.oreTag = MemoizingSuppliers.of(() -> {
            String tag = settings.getOreTagFunction().apply(material);
            return Strings.isNullOrEmpty((String)tag) ? null : MiscHelper.INSTANCE.getItemTagKey(new ResourceLocation(tag));
        });
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public int getTint() {
        return 0xFFFFFF & this.material.getColor();
    }

    public ResourceLocation getIcon() {
        if (MiscHelper.INSTANCE.hasResource(this.getRegistryName().m_247449_("textures/slurry/" + this.getRegistryName().m_135815_() + ".png"))) {
            return this.getRegistryName().m_247449_("slurry/" + this.getRegistryName().m_135815_());
        }
        return super.getIcon();
    }

    public Component getTextComponent() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("slurry.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }
}

