/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.createmetallurgy.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import fr.lucreeper74.createmetallurgy.content.casting.recipe.CastingOutput;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.compat.createmetallurgy.CreateMetallurgyHelper;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CastingTableRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object mold;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final int time;
    public final boolean consumeMold;

    public CastingTableRecipeSerializer(ResourceLocation key, Object mold, Object input, int inputAmount, Object output, int outputCount, int time, boolean consumeMold) {
        this.key = Objects.requireNonNull(key);
        this.mold = mold;
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.consumeMold = consumeMold;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.mold);
        FluidIngredient fluidIng = CreateHelper.INSTANCE.getFluidIngredient(this.input, this.inputAmount);
        if (fluidIng == null && ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.mold) + ", " + String.valueOf(this.input));
        }
        CastingOutput out = CreateMetallurgyHelper.INSTANCE.getCastingOutput(this.output, this.outputCount);
        if (out == null) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "createmetallurgy:casting_in_table");
        JsonArray ingJson = new JsonArray();
        if (ing != EmptyIngredient.INSTANCE) {
            ingJson.add(ing.m_43942_());
            json.addProperty("mold_consumed", Boolean.valueOf(this.consumeMold));
        }
        if (fluidIng != null) {
            ingJson.add((JsonElement)fluidIng.serialize());
        }
        json.add("ingredients", (JsonElement)ingJson);
        json.add("result", out.serialize());
        json.addProperty("processingTime", (Number)this.time);
        return json;
    }
}

