/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import weather2.ServerTickHandler;
import weather2.Weather;

public class PacketNBTFromClient {
    private final CompoundTag nbt;

    public PacketNBTFromClient(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encode(PacketNBTFromClient msg, FriendlyByteBuf buffer) {
        buffer.m_130079_(msg.nbt);
    }

    public static PacketNBTFromClient decode(FriendlyByteBuf buffer) {
        return new PacketNBTFromClient(buffer.m_130260_());
    }

    public static class Handler {
        public static void handle(PacketNBTFromClient msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer playerEntity = ctx.get().getSender();
            if (playerEntity == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(() -> {
                try {
                    CompoundTag nbt = msg.nbt;
                    String packetCommand = nbt.m_128461_("packetCommand");
                    String command = nbt.m_128461_("command");
                    Weather.dbg("Weather2 packet command from client: " + packetCommand + " - " + command);
                    if (packetCommand.equals("WeatherData") && command.equals("syncFull")) {
                        ServerTickHandler.playerClientRequestsFullSync(playerEntity);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

