/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.EvictingStack;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.InfoSectionTagIndex;
import org.cyclops.cyclopscore.init.ModBase;

public class InfoBook
implements IInfoBook {
    private final ModBase mod;
    private final int pagesPerView;
    private final String baseUrl;
    private final EvictingStack<InfoSection.Location> history = new EvictingStack(128);
    private int currentPage = 0;
    private InfoSection currentSection = null;
    private InfoSectionTagIndex tagIndex = null;
    private Map<String, Pair<InfoSection, Integer>> configLinks = Collections.emptyMap();
    private final Map<String, InfoSection> sections = Maps.newHashMap();

    @Override
    public void addSection(String sectionName, InfoSection section) {
        this.sections.put(sectionName, section);
    }

    @Override
    public InfoSection getSection(String sectionName) {
        return this.sections.get(sectionName);
    }

    @Override
    public void putIndex(InfoSectionTagIndex tagIndex) {
        this.tagIndex = tagIndex;
    }

    public InfoBook(ModBase mod, int pagesPerView, String baseUrl) {
        this.mod = mod;
        this.pagesPerView = pagesPerView;
        this.baseUrl = baseUrl;
    }

    public ModBase getMod() {
        return this.mod;
    }

    @Override
    public int getPagesPerView() {
        return this.pagesPerView;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public EvictingStack<InfoSection.Location> getHistory() {
        return this.history;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public InfoSection getCurrentSection() {
        return this.currentSection;
    }

    @Override
    public InfoSectionTagIndex getTagIndex() {
        return this.tagIndex;
    }

    @Override
    public Map<String, Pair<InfoSection, Integer>> getConfigLinks() {
        return this.configLinks;
    }

    public Map<String, InfoSection> getSections() {
        return this.sections;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    @Override
    public void setCurrentSection(InfoSection currentSection) {
        this.currentSection = currentSection;
    }

    public void setTagIndex(InfoSectionTagIndex tagIndex) {
        this.tagIndex = tagIndex;
    }

    @Override
    public void setConfigLinks(Map<String, Pair<InfoSection, Integer>> configLinks) {
        this.configLinks = configLinks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfoBook)) {
            return false;
        }
        InfoBook other = (InfoBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPagesPerView() != other.getPagesPerView()) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        ModBase this$mod = this.getMod();
        ModBase other$mod = other.getMod();
        if (this$mod == null ? other$mod != null : !((Object)this$mod).equals(other$mod)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        EvictingStack<InfoSection.Location> this$history = this.getHistory();
        EvictingStack<InfoSection.Location> other$history = other.getHistory();
        if (this$history == null ? other$history != null : !this$history.equals(other$history)) {
            return false;
        }
        InfoSection this$currentSection = this.getCurrentSection();
        InfoSection other$currentSection = other.getCurrentSection();
        if (this$currentSection == null ? other$currentSection != null : !this$currentSection.equals(other$currentSection)) {
            return false;
        }
        InfoSectionTagIndex this$tagIndex = this.getTagIndex();
        InfoSectionTagIndex other$tagIndex = other.getTagIndex();
        if (this$tagIndex == null ? other$tagIndex != null : !this$tagIndex.equals(other$tagIndex)) {
            return false;
        }
        Map<String, Pair<InfoSection, Integer>> this$configLinks = this.getConfigLinks();
        Map<String, Pair<InfoSection, Integer>> other$configLinks = other.getConfigLinks();
        if (this$configLinks == null ? other$configLinks != null : !((Object)this$configLinks).equals(other$configLinks)) {
            return false;
        }
        Map<String, InfoSection> this$sections = this.getSections();
        Map<String, InfoSection> other$sections = other.getSections();
        return !(this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfoBook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPagesPerView();
        result = result * 59 + this.getCurrentPage();
        ModBase $mod = this.getMod();
        result = result * 59 + ($mod == null ? 43 : ((Object)$mod).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        EvictingStack<InfoSection.Location> $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : $history.hashCode());
        InfoSection $currentSection = this.getCurrentSection();
        result = result * 59 + ($currentSection == null ? 43 : $currentSection.hashCode());
        InfoSectionTagIndex $tagIndex = this.getTagIndex();
        result = result * 59 + ($tagIndex == null ? 43 : $tagIndex.hashCode());
        Map<String, Pair<InfoSection, Integer>> $configLinks = this.getConfigLinks();
        result = result * 59 + ($configLinks == null ? 43 : ((Object)$configLinks).hashCode());
        Map<String, InfoSection> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        return result;
    }

    public String toString() {
        return "InfoBook(mod=" + String.valueOf(this.getMod()) + ", pagesPerView=" + this.getPagesPerView() + ", baseUrl=" + this.getBaseUrl() + ", history=" + String.valueOf(this.getHistory()) + ", currentPage=" + this.getCurrentPage() + ", currentSection=" + String.valueOf(this.getCurrentSection()) + ", tagIndex=" + String.valueOf(this.getTagIndex()) + ", configLinks=" + String.valueOf(this.getConfigLinks()) + ", sections=" + String.valueOf(this.getSections()) + ")";
    }
}

