/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class WrappedICurioProvider
implements Accessory,
LootingAdjustment,
FortuneAdjustment,
AllowWalkingOnSnow,
EndermanMasked,
PiglinNeutralInducer {
    public ICurio iCurio(ItemStack stack) {
        return (ICurio)stack.getCapability(CuriosCapability.ITEM).orElse(null);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurio(stack).curioTick(context);
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurio(stack).onEquip(context, ItemStack.f_41583_);
    }

    public void onUnequip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurio(stack).onUnequip(context, ItemStack.f_41583_);
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).canEquip(context);
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).canUnequip(context);
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        super.getDynamicModifiers(stack, reference, builder);
        Pair data = AttributeUtils.getModifierData((ResourceLocation)Accessories.of((String)AccessoryAttributeBuilder.createSlotPath((SlotReference)reference)));
        this.iCurio(stack).getAttributeModifiers(context, (UUID)data.right()).forEach((arg_0, arg_1) -> ((AccessoryAttributeBuilder)builder).addExclusive(arg_0, arg_1));
    }

    public DropRule getDropRule(ItemStack stack, SlotReference reference, DamageSource source) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return CuriosWrappingUtils.convert(this.iCurio(stack).getDropRule(context, source, 0, true));
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurio(stack).onEquipFromUse(context);
    }

    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        ICurio.SoundInfo info = this.iCurio(stack).getEquipSound(context);
        return new SoundEventData(info.soundEvent(), info.volume(), info.pitch());
    }

    public boolean canEquipFromUse(ItemStack stack) {
        try {
            return this.iCurio(stack).canEquipFromUse(null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void onBreak(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        this.iCurio(stack).curioBreak(context);
    }

    public void getAttributesTooltip(ItemStack stack, SlotType type, List<Component> tooltips, TooltipFlag tooltipType) {
        ArrayList<Component> copyData = new ArrayList<Component>(tooltips);
        List<Component> data = this.iCurio(stack).getAttributesTooltip(copyData);
        tooltips.clear();
        tooltips.addAll(data);
    }

    public void getExtraTooltip(ItemStack stack, List<Component> tooltips, TooltipFlag tooltipType) {
        ArrayList<Component> components = new ArrayList<Component>();
        List<Component> data = this.iCurio(stack).getSlotsTooltip(components);
        tooltips.addAll(data);
    }

    public int getLootingAdjustment(ItemStack stack, SlotReference reference, LivingEntity target, DamageSource damageSource, int currentLevel) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).getLootingLevel(context, damageSource, target, currentLevel);
    }

    public int getFortuneAdjustment(ItemStack stack, SlotReference reference, LootContext context, int currentLevel) {
        SlotContext slotContext = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).getFortuneLevel(slotContext, context);
    }

    public TriState makePiglinsNeutral(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).makesPiglinsNeutral(context) ? TriState.TRUE : TriState.DEFAULT;
    }

    public TriState allowWalkingOnSnow(ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).canWalkOnPowderedSnow(context) ? TriState.TRUE : TriState.DEFAULT;
    }

    public TriState isEndermanMasked(EnderMan enderMan, ItemStack stack, SlotReference reference) {
        SlotContext context = CuriosWrappingUtils.create(reference);
        return this.iCurio(stack).isEnderMask(context, enderMan) ? TriState.TRUE : TriState.DEFAULT;
    }
}

