/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

public class WrappedAccessory
implements ICurioItem {
    private final Accessory accessory;

    public WrappedAccessory(Accessory accessory) {
        this.accessory = accessory;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.accessory.tick(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        this.accessory.onEquip(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        this.accessory.onUnequip(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canEquip(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canUnequip(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        SlotReference ctx = CuriosWrappingUtils.fromContext(slotContext);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(ctx);
        this.accessory.getDynamicModifiers(stack, ctx, new AccessoryAttributeBuilder(ctx));
        return builder.getAttributeModifiers(false);
    }

    @Override
    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        this.accessory.onEquipFromUse(stack, CuriosWrappingUtils.fromContext(slotContext));
    }

    @Override
    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        SoundEventData data = this.accessory.getEquipSound(stack, CuriosWrappingUtils.fromContext(slotContext));
        if (data == null) {
            return new ICurio.SoundInfo(SoundEvents.f_11675_, 1.0f, 1.0f);
        }
        return new ICurio.SoundInfo(data.event(), data.volume(), data.pitch());
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canEquipFromUse(stack);
    }

    @Override
    public @NotNull ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return CuriosWrappingUtils.convert(this.accessory.getDropRule(stack, CuriosWrappingUtils.fromContext(slotContext), source));
    }

    @Override
    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        try {
            this.accessory.getAttributesTooltip(stack, null, tooltips, (TooltipFlag)TooltipFlag.f_256752_);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return tooltips;
    }

    @Override
    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof FortuneAdjustment) {
            FortuneAdjustment fortuneAdjustment = (FortuneAdjustment)accessory;
            return fortuneAdjustment.getFortuneAdjustment(stack, CuriosWrappingUtils.fromContext(slotContext), lootContext, 0);
        }
        return 0;
    }

    @Override
    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof LootingAdjustment) {
            LootingAdjustment lootingAdjustment = (LootingAdjustment)accessory;
            return lootingAdjustment.getLootingAdjustment(stack, CuriosWrappingUtils.fromContext(slotContext), target, source, baseLooting);
        }
        return 0;
    }

    @Override
    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof PiglinNeutralInducer) {
            PiglinNeutralInducer piglinNeutralInducer = (PiglinNeutralInducer)accessory;
            return piglinNeutralInducer.makePiglinsNeutral(stack, CuriosWrappingUtils.fromContext(slotContext)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof AllowWalkingOnSnow) {
            AllowWalkingOnSnow allowWalingOnSnow = (AllowWalkingOnSnow)accessory;
            return allowWalingOnSnow.allowWalkingOnSnow(stack, CuriosWrappingUtils.fromContext(slotContext)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof EndermanMasked) {
            EndermanMasked endermanMasked = (EndermanMasked)accessory;
            return endermanMasked.isEndermanMasked(enderMan, stack, CuriosWrappingUtils.fromContext(slotContext)).orElse(false);
        }
        return false;
    }
}

