/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.compat;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.compat.WrappedCurio;
import top.theillusivec4.curios.mixin.CuriosImplMixinHooks;

public class CuriosWrappingUtils {
    public static SlotContext create(SlotReference reference) {
        return CuriosWrappingUtils.create(reference, true);
    }

    public static SlotContext create(SlotReference reference, boolean visible) {
        return new SlotContext(CuriosWrappingUtils.accessoriesToCurios(reference.slotName()), reference.entity(), reference.slot(), false, visible);
    }

    public static SlotReference fromContext(SlotContext context) {
        return SlotReference.of((LivingEntity)context.entity(), (String)CuriosWrappingUtils.curiosToAccessories(context.identifier()), (int)context.index());
    }

    public static ICurio.DropRule convert(DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new IncompatibleClassChangeError();
            case DropRule.KEEP -> ICurio.DropRule.ALWAYS_KEEP;
            case DropRule.DROP -> ICurio.DropRule.ALWAYS_DROP;
            case DropRule.DESTROY -> ICurio.DropRule.DESTROY;
            case DropRule.DEFAULT -> ICurio.DropRule.DEFAULT;
        };
    }

    public static DropRule convert(ICurio.DropRule dropRule) {
        return switch (dropRule) {
            default -> throw new IncompatibleClassChangeError();
            case ICurio.DropRule.DEFAULT -> DropRule.DEFAULT;
            case ICurio.DropRule.ALWAYS_DROP -> DropRule.DROP;
            case ICurio.DropRule.ALWAYS_KEEP -> DropRule.KEEP;
            case ICurio.DropRule.DESTROY -> DropRule.DESTROY;
        };
    }

    public static TriState convert(Event.Result result) {
        if (result == null) {
            return TriState.DEFAULT;
        }
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case Event.Result.DENY -> TriState.FALSE;
            case Event.Result.ALLOW -> TriState.TRUE;
            case Event.Result.DEFAULT -> TriState.DEFAULT;
        };
    }

    public static Optional<Accessory> of(ItemStack stack) {
        return CuriosImplMixinHooks.getCurioFromRegistry(stack.m_41720_()).or(() -> {
            ICurioItem itemCurio;
            Item patt0$temp = stack.m_41720_();
            return Optional.ofNullable(patt0$temp instanceof ICurioItem ? (itemCurio = (ICurioItem)patt0$temp) : null);
        }).map(WrappedCurio::new);
    }

    public static String curiosToAccessories(String curiosType) {
        return switch (curiosType) {
            case "curio" -> "any";
            case "body" -> "cape";
            case "bracelet" -> "wrist";
            case "head" -> "hat";
            case "hands" -> "hand";
            case "feet" -> "shoes";
            default -> curiosType;
        };
    }

    public static String accessoriesToCurios(String accessoryType) {
        return switch (accessoryType) {
            case "any" -> "curio";
            case "cape" -> "body";
            case "wrist" -> "bracelet";
            case "hat" -> "head";
            case "hand" -> "hands";
            case "shoes" -> "feet";
            default -> accessoryType;
        };
    }

    public static ResourceLocation curiosToAccessories_Validators(ResourceLocation location) {
        return switch (location.toString()) {
            case "curios:all" -> Accessories.of((String)"all");
            case "curios:none" -> Accessories.of((String)"none");
            case "curios:tag" -> Accessories.of((String)"tag");
            default -> location;
        };
    }
}

