/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CurioItemHandler
implements IItemHandler {
    final IItemHandler curios;
    final LivingEntity livingEntity;

    public CurioItemHandler(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        LazyOptional<ICuriosItemHandler> handler = CuriosApi.getCuriosInventory(livingEntity);
        this.curios = handler.isPresent() ? ((ICuriosItemHandler)handler.orElseThrow(() -> new IllegalStateException("[CCLayer] Unable to get the required curios handler!"))).getEquippedCurios() : new ItemStackHandler();
    }

    public int getSlots() {
        return this.curios.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.curios.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.curios.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.curios.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.curios.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.curios.isItemValid(slot, stack);
    }
}

