/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.cclayer.mixin;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.slottype.SlotType;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;

@Mixin(value={SlotTypeLoader.class}, priority=900)
public abstract class SlotTypeLoaderMixin {
    @Unique
    private final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("curios", "slot/empty_curio_slot");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="INVOKE", target="Ljava/util/HashMap;<init>()V", shift=At.Shift.AFTER, ordinal=2)}, remap=false)
    private void injectCuriosSpecificSlots(Map<ResourceLocation, JsonObject> data, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci, @Local(name={"builders"}) HashMap<String, SlotTypeLoader.SlotBuilder> tempMap) {
        for (Map.Entry<String, SlotType.Builder> entry : CuriosSlotManager.SERVER.slotTypeBuilders.entrySet()) {
            SlotTypeLoader.SlotBuilder builder;
            String accessoryType = CuriosWrappingUtils.curiosToAccessories(entry.getKey());
            SlotType.Builder curiosBuilder = entry.getValue();
            if (tempMap.containsKey(accessoryType)) {
                builder = tempMap.get(accessoryType);
                Integer slotsCurrentSize = builder.baseAmount;
                if (curiosBuilder.size != null && slotsCurrentSize != null && curiosBuilder.size > slotsCurrentSize) {
                    builder.amount(curiosBuilder.size.intValue());
                }
                if (curiosBuilder.sizeMod != 0) {
                    builder.addAmount(curiosBuilder.sizeMod);
                }
            } else {
                ResourceLocation icon;
                builder = new SlotTypeLoader.SlotBuilder(accessoryType);
                if (curiosBuilder.size != null) {
                    builder.amount(curiosBuilder.size.intValue());
                }
                if (curiosBuilder.sizeMod != 0) {
                    builder.addAmount(curiosBuilder.sizeMod);
                }
                if ((icon = curiosBuilder.icon) != null && !icon.equals((Object)this.EMPTY_TEXTURE)) {
                    builder.icon(icon);
                }
                if (curiosBuilder.order != null) {
                    builder.order(curiosBuilder.order);
                }
                if (curiosBuilder.dropRule != null) {
                    builder.dropRule(CuriosWrappingUtils.convert(curiosBuilder.dropRule));
                }
                builder.alternativeTranslation("curios.identifier." + entry.getKey());
                tempMap.put(accessoryType, builder);
            }
            if (curiosBuilder.validators == null) continue;
            for (ResourceLocation validatorPredicate : curiosBuilder.validators) {
                builder.validator(CuriosWrappingUtils.curiosToAccessories_Validators(validatorPredicate));
            }
        }
    }
}

