/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.cclayer;

import io.wispforest.accessories.api.slot.SlotType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.WrappedSlotType;

public final class ImmutableDelegatingMap<K, V, I>
implements Map<K, V> {
    public final Class<K> keyClass;
    public final Class<V> valueClass;
    public final Map<K, I> map;
    public final UnaryOperator<K> toKeyNamespace;
    public final UnaryOperator<K> fromKeyNamespace;
    public final Function<I, V> toValueMapFunc;
    public final Function<V, @Nullable I> fromValueMapFunc;

    private ImmutableDelegatingMap(Class<K> keyClass, Class<V> valueClass, Map<K, I> map, UnaryOperator<K> toKeyNamespace, UnaryOperator<K> fromKeyNamespace, Function<I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.map = map;
        this.toKeyNamespace = toKeyNamespace;
        this.fromKeyNamespace = fromKeyNamespace;
        this.toValueMapFunc = toValueMapFunc;
        this.fromValueMapFunc = fromValueMapFunc;
    }

    public static <I, V> Map<String, V> of(Class<V> valueClass, Map<String, I> map, UnaryOperator<String> toKeyNamespace, UnaryOperator<String> fromKeyNamespace, Function<I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        return new ImmutableDelegatingMap<String, V, I>(String.class, valueClass, map, toKeyNamespace, fromKeyNamespace, toValueMapFunc, fromValueMapFunc);
    }

    public static Map<String, ISlotType> slotType(Map<String, SlotType> map) {
        return new ImmutableDelegatingMap<String, ISlotType, SlotType>(String.class, ISlotType.class, map, CuriosWrappingUtils::accessoriesToCurios, CuriosWrappingUtils::curiosToAccessories, WrappedSlotType::new, curiosSlot -> {
            SlotType slotType;
            if (curiosSlot instanceof WrappedSlotType) {
                WrappedSlotType wrappedSlotType = (WrappedSlotType)curiosSlot;
                slotType = wrappedSlotType.innerSlotType();
            } else {
                slotType = null;
            }
            return slotType;
        });
    }

    public static Map<String, ResourceLocation> slotIcon(Map<String, SlotType> map) {
        return new ImmutableDelegatingMap<String, ResourceLocation, SlotType>(String.class, ResourceLocation.class, map, CuriosWrappingUtils::accessoriesToCurios, CuriosWrappingUtils::curiosToAccessories, SlotType::icon, location -> null);
    }

    public static Map<String, Integer> slotBaseSize(Map<String, SlotType> map) {
        return new ImmutableDelegatingMap<String, Integer, SlotType>(String.class, Integer.class, map, CuriosWrappingUtils::accessoriesToCurios, CuriosWrappingUtils::curiosToAccessories, SlotType::amount, location -> null);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return false;
        }
        return this.map.containsKey(this.fromKeyNamespace.apply(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.valueClass.isInstance(value)) {
            return false;
        }
        I possibleValue = this.fromValueMapFunc.apply(value);
        return possibleValue != null && this.map.containsValue(possibleValue);
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return null;
        }
        I entry = this.map.get(this.fromKeyNamespace.apply(key));
        if (entry == null) {
            return null;
        }
        return this.toValueMapFunc.apply(entry);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet().stream().map(this.toKeyNamespace).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values().stream().map(this.toValueMapFunc).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet().stream().map(kiEntry -> Map.entry(this.toKeyNamespace.apply(kiEntry.getKey()), this.toValueMapFunc.apply(kiEntry.getValue()))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return null;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
    }
}

