/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.cclayer;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.compat.CuriosWrappingUtils;
import top.theillusivec4.curios.compat.WrappedCurioItemHandler;

public class DeathWrapperEventsImpl
implements OnDeathCallback,
OnDropCallback {
    public static final DeathWrapperEventsImpl INSTANCE = new DeathWrapperEventsImpl();
    @Nullable
    private DropRulesEvent latestDropRules = null;

    public static void init() {
        OnDeathCallback.EVENT.register((Object)INSTANCE);
        OnDropCallback.EVENT.register((Object)INSTANCE);
    }

    public TriState shouldDrop(TriState currentState, LivingEntity entity, AccessoriesCapability capability, DamageSource damageSource, List<ItemStack> droppedStacks) {
        WrappedCurioItemHandler handler = new WrappedCurioItemHandler(() -> (AccessoriesCapabilityImpl)capability);
        List<ItemEntity> itemEntities = droppedStacks.stream().map(stack -> {
            ItemEntity itemEntity = (ItemEntity)EntityType.f_20461_.m_20615_(entity.m_9236_());
            if (itemEntity == null) {
                return null;
            }
            itemEntity.m_32045_(stack);
            return itemEntity;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        droppedStacks.clear();
        CurioDropsEvent dropEventTest = new CurioDropsEvent(entity, handler, damageSource, itemEntities, 0, false);
        MinecraftForge.EVENT_BUS.post((Event)dropEventTest);
        droppedStacks.addAll(itemEntities.stream().map(ItemEntity::m_32055_).toList());
        if (dropEventTest.isCanceled()) {
            return TriState.FALSE;
        }
        DropRulesEvent event = new DropRulesEvent(entity, handler, damageSource, 0, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.latestDropRules = event;
        return TriState.DEFAULT;
    }

    @Nullable
    public DropRule onDrop(DropRule dropRule, ItemStack stack, SlotReference reference, DamageSource damageSource) {
        if (this.latestDropRules != null) {
            for (Tuple override : this.latestDropRules.getOverrides()) {
                if (!((Predicate)override.m_14418_()).test(stack)) continue;
                return CuriosWrappingUtils.convert((ICurio.DropRule)((Object)override.m_14419_()));
            }
        }
        return null;
    }
}

