/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import gg.galaxygaming.projectextended.client.rendering.ISTERProvider;
import gg.galaxygaming.projectextended.common.ProjectExtendedLang;
import gg.galaxygaming.projectextended.common.entity.PETridentEntity;
import java.util.List;
import java.util.function.Consumer;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PETrident
extends TridentItem
implements IItemCharge,
IItemMode,
IBarHelper {
    public static final byte NORMAL = 0;
    public static final byte CHANNELING = 1;
    public static final byte RIPTIDE = 2;
    public static final byte SHOCKWAVE = 3;
    private final ToolHelper.ChargeAttributeCache attributeCache = new ToolHelper.ChargeAttributeCache();
    private final Multimap<Attribute, AttributeModifier> baseAttributes;
    private final EnumMatterType matterType;
    private final ILangEntry[] modeDesc;
    private final int numCharges;
    private final float attackDamage;

    public PETrident(EnumMatterType matterType, int numCharges, float damage, Item.Properties props) {
        super(props);
        this.matterType = matterType;
        this.numCharges = numCharges;
        this.modeDesc = new ILangEntry[]{ProjectExtendedLang.MODE_TRIDENT_1, ProjectExtendedLang.MODE_TRIDENT_2, ProjectExtendedLang.MODE_TRIDENT_3, ProjectExtendedLang.MODE_TRIDENT_4};
        this.attackDamage = matterType.m_6631_() + damage;
        float attackSpeed = -2.7f + 0.2f * (float)this.getMatterTier();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.baseAttributes = builder.build();
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ISTERProvider.trident());
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public int getMatterTier() {
        return this.matterType.getMatterTier();
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public int getNumCharges(@NotNull ItemStack itemStack) {
        return this.numCharges;
    }

    public ILangEntry[] getModeLangEntries() {
        return this.modeDesc;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> list, @NotNull TooltipFlag flags) {
        list.add(this.getToolTip(stack));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityWrapper(stack, new ItemCapability[]{new ChargeItemCapabilityWrapper(), new ModeChangerItemCapabilityWrapper()});
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 10) {
                byte mode = this.getMode(stack);
                if (mode == 2 && !this.canUseRiptide(player)) {
                    return;
                }
                if (!world.f_46443_ && mode != 2) {
                    PETridentEntity trident = new PETridentEntity(world, (LivingEntity)player, stack);
                    trident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
                    if (player.m_7500_()) {
                        trident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.m_7967_((Entity)trident);
                    world.m_6269_(null, (Entity)trident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        player.m_150109_().m_36057_(stack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (mode == 2) {
                    int riptideLevel = this.getCharge(stack) + 1;
                    float toRadians = (float)Math.PI / 180;
                    float yaw = player.m_146908_() * toRadians;
                    float pitch = player.m_146909_() * toRadians;
                    float xVelocity = -Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch);
                    float yVelocity = -Mth.m_14031_((float)pitch);
                    float zVelocity = Mth.m_14089_((float)yaw) * Mth.m_14089_((float)pitch);
                    float velocity = Mth.m_14116_((float)(xVelocity * xVelocity + yVelocity * yVelocity + zVelocity * zVelocity));
                    float velocityModifier = (0.75f + 0.75f * (float)riptideLevel) / velocity;
                    player.m_5997_((double)(xVelocity * velocityModifier), (double)(yVelocity * velocityModifier), (double)(zVelocity * velocityModifier));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    world.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private boolean canUseRiptide(Player player) {
        return this.getMatterTier() > 0 || player.m_20070_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getMode(stack) == 2 && !this.canUseRiptide(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.baseAttributes;
        }
        return super.m_7167_(equipmentSlot);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, ItemStack stack) {
        return this.attributeCache.addChargeAttributeModifier(super.getAttributeModifiers(slot, stack), slot, stack);
    }

    public int m_6473_() {
        return 0;
    }
}

