/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common.integration.gamestages;

import gg.galaxygaming.projectextended.ProjectExtended;
import gg.galaxygaming.projectextended.common.BlacklistType;
import gg.galaxygaming.projectextended.common.network.to_client.PacketSyncBlacklist;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import moze_intel.projecte.api.ItemInfo;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EMCGameStageHelper {
    private static final Map<BlacklistType, GameStageBlacklist> BLACKLISTS = new EnumMap<BlacklistType, GameStageBlacklist>(BlacklistType.class);

    private EMCGameStageHelper() {
    }

    public static void handleSyncPacket(Map<BlacklistType, GameStageBlacklist> blacklists) {
        EMCGameStageHelper.clearBlacklist();
        BLACKLISTS.putAll(blacklists);
    }

    public static PacketSyncBlacklist syncPacket() {
        return new PacketSyncBlacklist(BLACKLISTS);
    }

    public static void clearBlacklist() {
        BLACKLISTS.clear();
    }

    public static void blacklist(BlacklistType blacklistType, ItemInfo itemInfo, String stage) {
        BLACKLISTS.computeIfAbsent(blacklistType, type -> new GameStageBlacklist()).blacklist(itemInfo, stage);
    }

    public static boolean isBlacklisted(Player player, ItemInfo reducedInfo, BlacklistType blacklistType) {
        GameStageBlacklist blacklist = BLACKLISTS.get((Object)blacklistType);
        return blacklist != null && !blacklist.getRequiredStages(reducedInfo).allMatch(stage -> GameStageHelper.hasStage((Player)player, (String)stage));
    }

    public static List<String> getMissingStages(Player player, ItemInfo reducedInfo, BlacklistType blacklistType) {
        GameStageBlacklist blacklist = BLACKLISTS.get((Object)blacklistType);
        if (blacklist == null) {
            return List.of();
        }
        return blacklist.getRequiredStages(reducedInfo).filter(stage -> !GameStageHelper.hasStage((Player)player, (String)stage)).sorted().toList();
    }

    public static class GameStageBlacklist {
        private final Map<ItemInfo, Set<String>> itemToGameStage = new HashMap<ItemInfo, Set<String>>();

        @Nullable
        public static GameStageBlacklist read(FriendlyByteBuf buffer) {
            Map itemToGameStage = buffer.m_236847_(buf -> ItemInfo.fromItem((ItemLike)((ItemLike)buf.readRegistryIdSafe(Item.class)), (CompoundTag)buf.m_130260_()), buf -> (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130277_));
            if (itemToGameStage.isEmpty()) {
                return null;
            }
            GameStageBlacklist blacklist = new GameStageBlacklist();
            blacklist.itemToGameStage.putAll(itemToGameStage);
            return blacklist;
        }

        private GameStageBlacklist() {
        }

        void blacklist(ItemInfo itemInfo, String stage) {
            if (!this.itemToGameStage.computeIfAbsent(itemInfo, item -> new HashSet()).add(stage)) {
                ProjectExtended.LOGGER.warn("Item: {} has duplicate blacklists for stage: {}", (Object)itemInfo, (Object)stage);
            }
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            buffer.m_236831_(this.itemToGameStage, (buf, itemInfo) -> {
                buf.writeRegistryId(ForgeRegistries.ITEMS, (Object)itemInfo.getItem());
                buf.m_130079_(itemInfo.getNBT());
            }, (buf, val) -> buf.m_236828_((Collection)val, FriendlyByteBuf::m_130070_));
        }

        public Stream<String> getRequiredStages(ItemInfo itemInfo) {
            Set stages = this.itemToGameStage.getOrDefault(itemInfo, Set.of());
            if (itemInfo.hasNBT()) {
                Set baseStages = this.itemToGameStage.getOrDefault(ItemInfo.fromItem((ItemLike)itemInfo.getItem()), Set.of());
                if (stages.isEmpty()) {
                    return baseStages.stream();
                }
                if (!baseStages.isEmpty()) {
                    return Stream.concat(stages.stream(), baseStages.stream()).distinct();
                }
            }
            return stages.stream();
        }
    }
}

