/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common.integration.gamestages;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gg.galaxygaming.projectextended.ProjectExtended;
import gg.galaxygaming.projectextended.common.BlacklistType;
import gg.galaxygaming.projectextended.common.integration.gamestages.EMCGameStageHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.NSSItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlacklistReader {
    private static final BlacklistType[] BLACKLIST_TYPES = BlacklistType.values();
    private static final ResourceLocation GLOBAL_FILE = ProjectExtended.rl("global_blacklist.json");
    private static final Codec<NSSItem> NSS_ITEM_CODEC = Codec.STRING.comapFlatMap(itemName -> {
        if (itemName.startsWith("#")) {
            return ResourceLocation.m_135837_((String)itemName.substring(1)).map(NSSItem::createTag);
        }
        int nbtStart = itemName.indexOf(123);
        if (nbtStart == -1) {
            return BlacklistReader.readItem(itemName).map(NSSItem::createItem);
        }
        return BlacklistReader.readItem(itemName.substring(0, nbtStart)).apply2(NSSItem::createItem, BlacklistReader.readNbt(itemName.substring(nbtStart)));
    }, AbstractNBTNSSTag::json);
    private static final Codec<Map<String, List<NSSItem>>> BLACKLIST_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)ExtraCodecs.m_144637_((Codec)NSS_ITEM_CODEC.listOf()));

    private static DataResult<CompoundTag> readNbt(String nbtAsString) {
        try {
            return DataResult.success((Object)TagParser.m_129359_((String)nbtAsString));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error(() -> "Not valid nbt: " + nbtAsString + " " + e.getMessage());
        }
    }

    private static DataResult<Item> readItem(String itemName) {
        return ResourceLocation.m_135837_((String)itemName).flatMap(registryName -> BuiltInRegistries.f_257033_.m_6612_(registryName).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown item: " + registryName)));
    }

    public static void readDataPacks(ResourceManager resourceManager) {
        EMCGameStageHelper.clearBlacklist();
        for (BlacklistType blacklistType : BLACKLIST_TYPES) {
            BlacklistReader.readResources(resourceManager.m_213829_(blacklistType.getBlacklistFile()), blacklistType);
        }
        BlacklistReader.readResources(resourceManager.m_213829_(GLOBAL_FILE), null);
    }

    private static void readResources(List<Resource> resources, @Nullable BlacklistType blacklistType) {
        for (Resource resource : resources) {
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    Map blacklistInfo = (Map)BLACKLIST_CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element)).getOrThrow(false, arg_0 -> ((Logger)ProjectExtended.LOGGER).error(arg_0));
                    blacklistInfo.forEach((stage, blacklist) -> {
                        for (NSSItem nssItem : blacklist) {
                            if (nssItem.representsTag()) {
                                nssItem.forEachElement(nss -> {
                                    if (nss instanceof NSSItem) {
                                        NSSItem asItem = (NSSItem)nss;
                                        BlacklistReader.blacklist(blacklistType, asItem, stage);
                                    }
                                });
                                continue;
                            }
                            BlacklistReader.blacklist(blacklistType, nssItem, stage);
                        }
                    });
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                ProjectExtended.LOGGER.error("Could not load resource {}", (Object)(blacklistType == null ? GLOBAL_FILE : blacklistType.getBlacklistFile()), (Object)e);
            }
            catch (JsonParseException e) {
                ProjectExtended.LOGGER.error("Malformed JSON in file: {}", (Object)(blacklistType == null ? GLOBAL_FILE : blacklistType.getBlacklistFile()), (Object)e);
            }
        }
    }

    private static void blacklist(@Nullable BlacklistType blacklistType, NSSItem nssItem, String stage) {
        ItemInfo itemInfo = ItemInfo.fromNSS((NSSItem)nssItem);
        if (itemInfo != null) {
            BlacklistReader.blacklist(blacklistType, itemInfo, stage);
        }
    }

    private static void blacklist(@Nullable BlacklistType blacklistType, ItemInfo itemInfo, String stage) {
        if (blacklistType == null) {
            for (BlacklistType type : BLACKLIST_TYPES) {
                EMCGameStageHelper.blacklist(type, itemInfo, stage);
            }
        } else {
            EMCGameStageHelper.blacklist(blacklistType, itemInfo, stage);
        }
    }
}

