/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common.entity;

import gg.galaxygaming.projectextended.common.items.PETrident;
import gg.galaxygaming.projectextended.common.registries.ProjectExtendedEntityTypes;
import gg.galaxygaming.projectextended.common.registries.ProjectExtendedItems;
import java.util.function.Predicate;
import moze_intel.projecte.gameObjs.items.ItemPE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PETridentEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> SLAY_MOB = entity -> !entity.m_5833_() && entity instanceof Enemy;
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(PETridentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack tridentItem = new ItemStack(ProjectExtendedItems.DARK_MATTER_TRIDENT);
    private boolean dealtDamage;
    private boolean noReturn;
    private int loyaltyLevel;
    private int matterTier;
    private int clientSideReturnTridentTickCount;

    public PETridentEntity(EntityType<? extends PETridentEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public PETridentEntity(Level world, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)ProjectExtendedEntityTypes.PE_TRIDENT.get(), thrower, world);
        this.setStackAndLoyalty(thrownStackIn.m_41777_());
        this.f_19804_.m_135381_(ID_FOIL, (Object)thrownStackIn.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    private void setStackAndLoyalty(@NotNull ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof PETrident) {
            PETrident trident = (PETrident)item;
            this.tridentItem = stack;
            this.matterTier = trident.getMatterTier();
            this.loyaltyLevel = trident.getCharge(stack) + 1;
        }
    }

    public int getMatterTier() {
        return this.matterTier;
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    public void m_8119_() {
        Entity entity;
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
            boolean bl = this.noReturn = !this.isAcceptableReturnOwner();
        }
        if (!this.noReturn && (this.dealtDamage || this.m_36797_()) && (entity = this.m_19749_()) != null) {
            if (this.isAcceptableReturnOwner()) {
                this.m_36790_(true);
                Vec3 returnVector = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + returnVector.f_82480_ * 0.015 * (double)this.loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(returnVector.m_82541_().m_82490_(0.05 * (double)this.loyaltyLevel)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            } else {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(@NotNull Vec3 startVec, @NotNull Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity hitEntity = result.m_82443_();
        PETrident trident = (PETrident)this.tridentItem.m_41720_();
        int charge = trident.getCharge(this.tridentItem);
        float damage = trident.getDamage() + (float)charge;
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.tridentItem, (MobType)livingHit.m_6336_());
        }
        Entity thrower = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(thrower == null ? this : thrower));
        this.dealtDamage = true;
        if (hitEntity.m_6469_(damagesource, damage) && hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            if (thrower instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingHit, (Entity)thrower);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)thrower), (Entity)livingHit);
            }
            this.m_7761_(livingHit);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float volume = 1.0f;
        SoundEvent sound = SoundEvents.f_12514_;
        byte mode = trident.getMode(this.tridentItem);
        if (mode == 1) {
            if (this.trySummonLightning(charge + 1, hitEntity.m_20183_(), thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null)) {
                sound = SoundEvents.f_12521_;
                volume = 5.0f;
            }
        } else if (mode == 3 && this.tryCreateShockwave(charge, trident.getDamage(), thrower instanceof LivingEntity ? (LivingEntity)thrower : null)) {
            volume = 5.0f;
        }
        this.m_5496_(sound, volume, 1.0f);
    }

    protected void m_8060_(BlockHitResult result) {
        this.f_36696_ = this.m_9236_().m_8055_(result.m_82425_());
        this.f_36696_.m_60669_(this.m_9236_(), this.f_36696_, result, (Projectile)this);
        Vec3 motion = result.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(motion);
        Vec3 vec3d1 = motion.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec3d1.f_82479_, this.m_20186_() - vec3d1.f_82480_, this.m_20189_() - vec3d1.f_82481_);
        SoundEvent sound = this.m_36784_();
        float volume = 1.0f;
        float pitch = 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f);
        BlockPos hitPosition = result.m_82425_();
        Entity thrower = this.m_19749_();
        PETrident trident = (PETrident)this.tridentItem.m_41720_();
        int charge = trident.getCharge(this.tridentItem);
        byte mode = trident.getMode(this.tridentItem);
        if (mode == 1) {
            if (this.trySummonLightning(charge + 1, hitPosition.m_7494_(), thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null)) {
                sound = SoundEvents.f_12521_;
                volume = 5.0f;
                pitch = 1.0f;
            }
        } else if (mode == 3 && this.tryCreateShockwave(charge, trident.getDamage(), thrower instanceof LivingEntity ? (LivingEntity)thrower : null)) {
            volume = 5.0f;
            pitch = 1.0f;
        }
        this.m_5496_(sound, volume, pitch);
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(SoundEvents.f_11685_);
        this.m_36793_(false);
        this.m_36723_();
    }

    private boolean trySummonLightning(int bolts, BlockPos hitPos, @Nullable ServerPlayer thrower) {
        if (this.m_9236_() instanceof ServerLevel && (this.matterTier > 0 || this.m_9236_().m_46470_()) && this.m_9236_().m_46861_(hitPos)) {
            boolean hasAction = false;
            for (int i = 0; i < bolts && (thrower == null || ItemPE.consumeFuel((Player)thrower, (ItemStack)this.tridentItem, (long)64L, (boolean)true)); ++i) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                if (lightning != null) {
                    lightning.m_20219_(Vec3.m_82539_((Vec3i)hitPos));
                    lightning.m_20879_(thrower);
                    this.m_9236_().m_7967_((Entity)lightning);
                }
                hasAction = true;
            }
            return hasAction;
        }
        return false;
    }

    private boolean tryCreateShockwave(int charge, float damage, @Nullable LivingEntity thrower) {
        if (this.m_9236_() instanceof ServerLevel && (this.matterTier > 0 || thrower != null && thrower.m_20070_())) {
            DamageSource src = this.m_269291_().m_269525_((Entity)this, (Entity)(thrower == null ? this : thrower));
            float damageToDo = damage + (float)charge;
            int distance = charge + 1;
            for (Entity entity : this.m_9236_().m_6249_((Entity)thrower, this.m_20191_().m_82400_((double)distance), SLAY_MOB)) {
                entity.m_6469_(src, damageToDo);
            }
            AreaEffectCloud particle = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            particle.m_19718_(thrower);
            particle.m_19724_((ParticleOptions)ParticleTypes.f_123797_);
            particle.m_19712_((float)distance);
            particle.m_19734_(0);
            this.m_9236_().m_7967_((Entity)particle);
            return true;
        }
        return false;
    }

    protected boolean m_142470_(@NotNull Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(@NotNull Player entity) {
        if (this.m_150171_((Entity)entity) || this.m_19749_() == null) {
            super.m_6123_(entity);
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Trident", 10)) {
            this.setStackAndLoyalty(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Trident")));
        }
        this.dealtDamage = compound.m_128471_("DealtDamage");
        this.noReturn = compound.m_128471_("NoReturn");
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Trident", (Tag)this.tridentItem.serializeNBT());
        compound.m_128379_("DealtDamage", this.dealtDamage);
        compound.m_128379_("NoReturn", this.noReturn);
    }

    protected void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        } else if (this.noReturn && !this.m_9236_().f_46443_) {
            this.m_5552_(this.m_7941_(), 0.1f);
            this.m_146870_();
        }
    }

    protected float m_6882_() {
        return 0.99f + 0.5f * (float)(this.getMatterTier() + 1);
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.tridentItem);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setStackAndLoyalty(buffer.m_130267_());
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.tridentItem.m_41777_();
    }
}

