/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common.block_entity;

import gg.galaxygaming.projectextended.common.container.AlchemicalBarrelContainer;
import gg.galaxygaming.projectextended.common.registries.ProjectExtendedBlockEntityTypes;
import gg.galaxygaming.projectextended.common.registries.ProjectExtendedBlocks;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.gameObjs.block_entities.CapabilityEmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class AlchemicalBarrelBlockEntity
extends CapabilityEmcBlockEntity
implements MenuProvider {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            AlchemicalBarrelBlockEntity.this.playSound(state, SoundEvents.f_11725_);
            AlchemicalBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            AlchemicalBarrelBlockEntity.this.playSound(state, SoundEvents.f_11724_);
            AlchemicalBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int oldCount, int openCount) {
        }

        protected boolean m_142718_(Player player) {
            AlchemicalBarrelContainer container;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof AlchemicalBarrelContainer && (container = (AlchemicalBarrelContainer)abstractContainerMenu).blockEntityMatches(AlchemicalBarrelBlockEntity.this);
        }
    };
    private final BarrelInventory inventory = new BarrelInventory();
    private boolean inventoryChanged;

    public AlchemicalBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(ProjectExtendedBlockEntityTypes.ALCHEMICAL_BARREL, pos, state, 1000L);
        this.itemHandlerResolver = BasicCapabilityResolver.getBasicItemHandlerResolver((IItemHandler)this.inventory);
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, AlchemicalBarrelBlockEntity barrel) {
        for (int i = 0; i < barrel.inventory.getSlots(); ++i) {
            ItemStack stack = barrel.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stack.getCapability(PECapabilities.ALCH_CHEST_ITEM_CAPABILITY).ifPresent(alchChestItem -> alchChestItem.updateInAlchChest(level, pos, stack));
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, AlchemicalBarrelBlockEntity barrel) {
        for (int i = 0; i < barrel.inventory.getSlots(); ++i) {
            ItemStack stack = barrel.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int slotId = i;
            stack.getCapability(PECapabilities.ALCH_CHEST_ITEM_CAPABILITY).ifPresent(alchChestItem -> {
                if (alchChestItem.updateInAlchChest(level, pos, stack)) {
                    barrel.inventory.onContentsChanged(slotId);
                }
            });
        }
        if (barrel.inventoryChanged) {
            barrel.inventoryChanged = false;
            level.m_7260_(pos, state, state, 2);
        }
        barrel.updateComparators();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128391_(this.inventory.serializeNBT());
    }

    public void startOpen(Player player) {
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.m_58901_() && this.f_58857_ != null) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(open)));
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerIn) {
        return new AlchemicalBarrelContainer(windowId, playerInventory, this);
    }

    @NotNull
    public Component m_5446_() {
        return TextComponentUtil.build((Object[])new Object[]{ProjectExtendedBlocks.ALCHEMICAL_BARREL});
    }

    private class BarrelInventory
    extends EmcBlockEntity.StackHandler {
        protected BarrelInventory() {
            super((EmcBlockEntity)AlchemicalBarrelBlockEntity.this, 104);
        }

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (AlchemicalBarrelBlockEntity.this.f_58857_ != null && !((AlchemicalBarrelBlockEntity)AlchemicalBarrelBlockEntity.this).f_58857_.f_46443_) {
                AlchemicalBarrelBlockEntity.this.inventoryChanged = true;
            }
        }
    }
}

