/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.projectextended.common;

import gg.galaxygaming.projectextended.ProjectExtended;
import gg.galaxygaming.projectextended.common.ProjectExtendedLang;
import gg.galaxygaming.projectextended.common.ProjectExtendedTags;
import gg.galaxygaming.projectextended.common.config.ProjectExtendedConfig;
import gg.galaxygaming.projectextended.common.integration.ProjectExtendedHooks;
import gg.galaxygaming.projectextended.common.integration.gamestages.EMCGameStageHelper;
import java.util.List;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.utils.LazyTagLookup;
import moze_intel.projecte.utils.text.ILangEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public enum BlacklistType {
    CONDENSER("condenser", ProjectExtendedTags.Items.BLACKLIST_CONDENSER, ProjectExtendedLang.WARNING_BLACKLIST_CONDENSER, ProjectExtendedLang.WARNING_BLACKLIST_CONDENSER_STAGES),
    LEARNING("learning", ProjectExtendedTags.Items.BLACKLIST_LEARNING, ProjectExtendedLang.WARNING_BLACKLIST_TRANSMUTATION, ProjectExtendedLang.WARNING_BLACKLIST_TRANSMUTATION_STAGES);

    private final ResourceLocation blacklistFile;
    private final TagKey<Item> blacklist;
    private final LazyTagLookup<Item> lookup;
    private final ILangEntry warning;
    private final ILangEntry gameStageWarning;

    private BlacklistType(String name, TagKey<Item> blacklist, ILangEntry warning, ILangEntry gameStageWarning) {
        this.blacklistFile = ProjectExtended.rl(name + "_blacklist.json");
        this.blacklist = blacklist;
        this.lookup = LazyTagLookup.create((IForgeRegistry)ForgeRegistries.ITEMS, this.blacklist);
        this.warning = warning;
        this.gameStageWarning = gameStageWarning;
    }

    public ResourceLocation getBlacklistFile() {
        return this.blacklistFile;
    }

    public TagKey<Item> getBlacklist() {
        return this.blacklist;
    }

    private Component getWarning() {
        return this.warning.translateColored(ChatFormatting.YELLOW, new Object[0]);
    }

    public boolean isBlacklisted(Player player, ItemInfo sourceInfo, ItemInfo reducedInfo) {
        if (this.lookup.contains((Object)reducedInfo.getItem())) {
            return true;
        }
        if (ProjectExtendedHooks.gameStagesLoaded) {
            return EMCGameStageHelper.isBlacklisted(player, reducedInfo, this);
        }
        return false;
    }

    public void addBlacklistWarnings(Player player, ItemStack stack, List<Component> tooltips) {
        ItemInfo sourceInfo;
        ItemInfo reducedInfo;
        List<String> missingStages;
        if (stack.m_204117_(this.blacklist)) {
            tooltips.add(this.getWarning());
        } else if (ProjectExtendedHooks.gameStagesLoaded && !(missingStages = EMCGameStageHelper.getMissingStages(player, reducedInfo = IEMCProxy.INSTANCE.getPersistentInfo(sourceInfo = ItemInfo.fromStack((ItemStack)stack)), this)).isEmpty()) {
            tooltips.add(this.getWarning());
            if (((Boolean)ProjectExtendedConfig.server.showMissingGameStages.get()).booleanValue()) {
                tooltips.add((Component)this.gameStageWarning.translateColored(ChatFormatting.YELLOW, new Object[0]));
                for (String missingStage : missingStages) {
                    tooltips.add((Component)ProjectExtendedLang.LIST_ELEMENT.translateColored(ChatFormatting.YELLOW, new Object[]{missingStage}));
                }
            }
        }
    }
}

