/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.EggLayingAnimal;
import com.starfish_studios.naturalist.common.entity.core.HidingAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.EggLayingBreedGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.HideGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.LayEggGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tortoise
extends TamableAnimal
implements NaturalistGeoEntity,
HidingAnimal,
EggLayingAnimal {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient TEMPT_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.TORTOISE_TEMPT_ITEMS);
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int layEggCounter;
    boolean isDigging;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.tortoise.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.tortoise.walk");
    protected static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.sf_nba.tortoise.sit");
    protected static final RawAnimation HIDE = RawAnimation.begin().thenPlay("animation.sf_nba.tortoise.hide").thenLoop("animation.sf_nba.tortoise.hide_idle");
    protected static final RawAnimation DIG = RawAnimation.begin().thenLoop("animation.sf_nba.tortoise.dig");
    protected static final RawAnimation HURT = RawAnimation.begin().thenLoop("animation.sf_nba.tortoise.hurt");

    public Tortoise(@NotNull EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.17f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12346_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        Tortoise tortoise = (Tortoise)NaturalistEntityTypes.TORTOISE.get().m_20615_((Level)level);
        if (otherParent instanceof Tortoise) {
            Tortoise tortoiseParent = (Tortoise)otherParent;
            assert (tortoise != null);
            if (this.getVariant() == tortoiseParent.getVariant()) {
                tortoise.setVariant(this.getVariant());
            } else {
                tortoise.setVariant(this.f_19796_.m_188499_() ? tortoiseParent.getVariant() : this.getVariant());
            }
            tortoise.m_21816_(this.f_19796_.m_188499_() ? tortoiseParent.m_21805_() : this.m_21805_());
        }
        return tortoise;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        Holder holder = level.m_204166_(this.m_20183_());
        if (holder.m_203565_(Biomes.f_48207_) || holder.m_203565_(Biomes.f_220595_)) {
            this.setVariant(1);
        } else if (holder.m_203656_(BiomeTags.f_207610_) || holder.m_203565_(Biomes.f_48151_)) {
            this.setVariant(2);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21153_(30.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new EggLayingBreedGoal<Tortoise>(this, 1.0));
        this.f_21345_.m_25352_(1, new LayEggGoal<Tortoise>(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, new HideGoal<Tortoise>(this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPT_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof Tortoise)) {
            return false;
        }
        Tortoise tortoise = (Tortoise)otherAnimal;
        return tortoise.m_21824_() && super.m_7848_(otherAnimal);
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPT_ITEMS.test(stack);
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(this.m_21825_() || this.canHide() ? strength / 4.0 : strength, x, z);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, this.canHide() ? amount * 0.8f : amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(itemStack) && (this.m_21223_() < this.m_21233_() || !this.m_21824_())) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemStack);
                    this.m_5634_(3.0f);
                    return InteractionResult.CONSUME;
                }
                InteractionResult interactionResult2 = super.m_6071_(player, hand);
                if (!interactionResult2.m_19077_() || this.m_6162_()) {
                    this.m_21839_(!this.m_21827_());
                }
                return interactionResult2;
            }
        } else if (this.m_6898_(itemStack)) {
            this.m_142075_(player, hand, itemStack);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionResult = super.m_6071_(player, hand)).m_19077_()) {
            this.m_21530_();
        }
        return interactionResult;
    }

    @Override
    public boolean canHide() {
        if (this.m_21824_()) {
            return false;
        }
        List players = this.m_9236_().m_45955_(TargetingConditions.m_148353_().m_26883_(5.0).m_26888_(livingEntity -> EntitySelector.f_20406_.test(livingEntity) && !livingEntity.m_20163_() && !livingEntity.m_21093_((Predicate)TEMPT_ITEMS)), (LivingEntity)this, this.m_20191_().m_82377_(5.0, 3.0, 5.0));
        return !players.isEmpty();
    }

    protected float m_6108_() {
        return 0.96f;
    }

    protected float m_6431_(Pose pose, @NotNull EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.3f;
    }

    public double m_20204_() {
        return 0.4;
    }

    public boolean m_6040_() {
        return true;
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT_ID)), (int)0, (int)2);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)variant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("HasEgg", this.hasEgg());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setHasEgg(compound.m_128471_("HasEgg"));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        super.m_7355_(pos, state);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <T extends Tortoise> PlayState predicate(AnimationState<T> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(SIT);
            return PlayState.CONTINUE;
        }
        if (this.isLayingEgg()) {
            event.getController().setAnimation(DIG);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(WALK);
            if (this.m_6162_()) {
                event.getController().setAnimationSpeed(2.0);
            } else {
                event.getController().setAnimationSpeed(1.3);
            }
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends Tortoise> PlayState hidePredicate(@NotNull AnimationState<T> event) {
        if (this.canHide()) {
            event.getController().setAnimation(HIDE);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private <T extends Tortoise> PlayState hurtPredicate(AnimationState<T> event) {
        if (this.f_20916_ > 0) {
            event.getController().setAnimation(HURT);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hurtController", 5, this::hurtPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hideController", 0, this::hidePredicate).setSoundKeyframeHandler(this::soundListener)});
    }

    private void soundListener(SoundKeyframeEvent<Tortoise> event) {
        Tortoise animatable = (Tortoise)event.getAnimatable();
        if (animatable.m_9236_().f_46443_) {
            if (event.getKeyframeData().getSound().equals("hide")) {
                animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), NaturalistSoundEvents.TORTOISE_HIDE.get(), animatable.m_5720_(), 0.5f, 1.0f, false);
            }
            if (event.getKeyframeData().getSound().equals("thud")) {
                animatable.m_9236_().m_7785_(animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_(), NaturalistSoundEvents.TORTOISE_THUD.get(), animatable.m_5720_(), 0.5f, 1.0f, false);
            }
        }
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean isLayingEgg) {
        this.f_19804_.m_135381_(LAYING_EGG, (Object)isLayingEgg);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    @Override
    public Block getEggBlock() {
        return NaturalistRegistry.TORTOISE_EGG.get();
    }

    @Override
    public TagKey<Block> getEggLayableBlockTag() {
        return NaturalistTags.BlockTags.TORTOISE_EGG_LAYABLE_ON;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.hasEgg();
    }

    public void m_8107_() {
        super.m_8107_();
        BlockPos pos = this.m_20183_();
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0 && this.m_9236_().m_8055_(pos.m_7495_()).m_204336_(this.getEggLayableBlockTag())) {
            this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(pos.m_7495_())));
        }
    }
}

