/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.portal;

import com.google.common.collect.ImmutableSet;
import fathertoast.crust.api.portal.PortalBuilder;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class NetherPortalBuilder
extends PortalBuilder {
    private static final Set<ResourceLocation> VALID_DIMENSIONS = ImmutableSet.of((Object)Level.f_46428_.m_135782_(), (Object)Level.f_46429_.m_135782_());

    @Override
    public boolean isValidDimension(ResourceLocation dimension) {
        return VALID_DIMENSIONS.contains(dimension);
    }

    @Override
    public void generate(Level level, BlockPos.MutableBlockPos currentPos, Direction forward) {
        Direction transverse = forward.m_122427_();
        currentPos.m_122175_(transverse, -1);
        BlockPos portalCorner = currentPos.m_7949_();
        currentPos.m_122175_(transverse, -1);
        currentPos.m_122175_(Direction.UP, -1);
        BlockState frameBlock = Blocks.f_50080_.m_49966_();
        BlockPos frameCorner = currentPos.m_7949_();
        for (int tv = 0; tv < 5; ++tv) {
            for (int up = 0; up < 5; ++up) {
                if (tv != 0 && tv != 4 && up != 0 && up != 4) continue;
                currentPos.m_122190_((Vec3i)frameCorner).m_122175_(transverse, tv).m_122175_(Direction.UP, up);
                level.m_7731_((BlockPos)currentPos, frameBlock, 3);
            }
        }
        BlockState portalBlock = (BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)transverse.m_122434_());
        for (int tv = 0; tv < 3; ++tv) {
            for (int up = 0; up < 3; ++up) {
                currentPos.m_122190_((Vec3i)portalCorner).m_122175_(transverse, tv).m_122175_(Direction.UP, up);
                level.m_7731_((BlockPos)currentPos, portalBlock, 3);
            }
        }
    }
}

