/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.mode.type;

import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fathertoast.crust.api.lib.NBTHelper;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.CrustModesData;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class CrustMode<T> {
    public final String ID;
    public final Supplier<Integer> OP_LEVEL;
    protected final ICommandHandler<T> VALIDATOR;

    public CrustMode(String id, Supplier<Integer> opLevel) {
        this(id, opLevel, null);
    }

    public CrustMode(String id, Supplier<Integer> opLevel, @Nullable ICommandHandler<T> validator) {
        this.ID = id;
        this.OP_LEVEL = opLevel;
        this.VALIDATOR = validator;
        CrustModes.register(this);
    }

    public final boolean enabled(@Nullable Player player) {
        return player != null && CrustModesData.of(player).enabled(this);
    }

    public boolean enabled(CompoundTag tag) {
        return NBTHelper.containsNumber(tag, this.ID);
    }

    public abstract T get(CompoundTag var1);

    public abstract void enable(CompoundTag var1, T var2);

    public void disable(CompoundTag tag) {
        tag.m_128473_(this.ID);
    }

    public abstract RequiredArgumentBuilder<CommandSourceStack, ?> commandArgument(String var1);

    public abstract void onCommand(CommandContext<CommandSourceStack> var1, @Nullable String var2, ServerPlayer var3);

    protected void validate(ServerPlayer player, @Nullable T value) {
        if (this.VALIDATOR != null) {
            value = this.VALIDATOR.validate(player, value);
        }
        if (value == null) {
            CrustModesData.of((Player)player).disable(this);
        } else {
            CrustModesData.of((Player)player).enable(this, value);
        }
    }

    public static interface ICommandHandler<T> {
        @Nullable
        public T validate(ServerPlayer var1, @Nullable T var2);
    }
}

