/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.mode;

import fathertoast.crust.api.lib.NBTHelper;
import fathertoast.crust.common.config.CrustConfig;
import fathertoast.crust.common.config.CrustModesConfigFile;
import fathertoast.crust.common.core.CrustForgeEvents;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.type.CrustMode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class CrustModesData {
    public static final String TAG_NAME = "modes";
    private final Player PLAYER;
    private final CompoundTag SAVE_TAG;

    public static CrustModesData of(Player player) {
        return new CrustModesData(player);
    }

    private CrustModesData(Player player) {
        this.PLAYER = player;
        CompoundTag modTag = NBTHelper.getPlayerData(player, "crust");
        boolean setDefaults = !player.m_9236_().m_5776_() && !NBTHelper.containsCompound(modTag, TAG_NAME);
        this.SAVE_TAG = NBTHelper.getOrCreateCompound(modTag, TAG_NAME);
        if (setDefaults) {
            CrustModesConfigFile.General config = CrustConfig.MODES.GENERAL;
            if (config.magnetDefault.get() > 0.0) {
                this.enable(CrustModes.MAGNET, Float.valueOf(config.magnetDefault.getFloat()));
            }
            if (config.undyingDefault.get()) {
                this.enable(CrustModes.UNDYING, (byte)1);
            }
            if (config.unbreakingDefault.get()) {
                this.enable(CrustModes.UNBREAKING, (byte)1);
            }
            if (config.uneatingDefault.get() > 0) {
                this.enable(CrustModes.UNEATING, config.uneatingDefault.getByte());
            }
            if (config.visionDefault.get()) {
                this.enable(CrustModes.SUPER_VISION, (byte)1);
            }
            if (config.speedDefault.get() > 1.0) {
                this.enable(CrustModes.SUPER_SPEED, Float.valueOf(config.speedDefault.getFloat()));
            }
            if (config.noPickupDefault.get()) {
                this.enable(CrustModes.DESTROY_ON_PICKUP, (byte)1);
            }
        }
    }

    public String toString() {
        return this.PLAYER.m_6302_() + ":" + this.SAVE_TAG.toString();
    }

    public boolean enabled(CrustMode<?> mode) {
        return mode.enabled(this.SAVE_TAG);
    }

    public <T> T get(CrustMode<T> mode) {
        return mode.get(this.SAVE_TAG);
    }

    public <T> void enable(CrustMode<T> mode, T data) {
        if (!this.get(mode).equals(data)) {
            mode.enable(this.SAVE_TAG, data);
            if (!this.PLAYER.m_9236_().m_5776_()) {
                CrustForgeEvents.markModesDirty(this.PLAYER);
            }
        }
    }

    public void disable(CrustMode<?> mode) {
        if (mode.enabled(this.SAVE_TAG)) {
            mode.disable(this.SAVE_TAG);
            if (!this.PLAYER.m_9236_().m_5776_()) {
                CrustForgeEvents.markModesDirty(this.PLAYER);
            }
        }
    }

    public CompoundTag getSaveTag() {
        return this.SAVE_TAG;
    }
}

