/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.config;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.InjectionWrapperField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.common.config.CrustConfig;
import fathertoast.crust.common.core.Crust;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.level.GameRules;

public class GameRulesCrustConfigFile
extends AbstractConfigFile {
    public final BooleanField enabled;

    GameRulesCrustConfigFile(ConfigManager cfgManager, String cfgName) {
        super(cfgManager, cfgName, "This config allows the default game rules for world creation to be altered. Many game rules make testing easier, so this is handy when you need to repeatedly generate new worlds.", "", "For more information on game rules, see the in-game descriptions in the 'Create New World' menu or the Minecraft Wiki article (https://minecraft.fandom.com/wiki/Game_rule).");
        this.SPEC.newLine(2);
        this.SPEC.decreaseIndent();
        this.enabled = this.SPEC.define(new BooleanField("config_enabled", false, "Whether this config file is enabled."), RestartNote.GAME_PARTIAL);
        this.SPEC.increaseIndent();
        ArrayList rules = new ArrayList(GameRules.f_46129_.entrySet());
        for (Category category : Category.values()) {
            new GRConfigCategory(this, category, rules);
        }
    }

    public static enum Category {
        PLAYER(GameRules.Category.PLAYER),
        MOBS(GameRules.Category.MOBS),
        SPAWNING(GameRules.Category.SPAWNING),
        DROPS(GameRules.Category.DROPS),
        UPDATES(GameRules.Category.UPDATES),
        CHAT(GameRules.Category.CHAT),
        MISC(GameRules.Category.MISC);

        public final GameRules.Category BASE;

        private Category(GameRules.Category base) {
            this.BASE = base;
        }

        static {
            if (Category.values().length != GameRules.Category.values().length) {
                Crust.LOG.error("Game rule config category count is unexpected! May break default game rule settings. :(");
            }
        }
    }

    public static class GRConfigCategory
    extends AbstractConfigCategory<GameRulesCrustConfigFile> {
        GRConfigCategory(GameRulesCrustConfigFile parent, Category category, List<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> rules) {
            super(parent, category.name().toLowerCase(Locale.ROOT), "Default game rule settings for the '" + category.name().toLowerCase() + "' category.");
            for (Map.Entry<GameRules.Key<?>, GameRules.Type<?>> rule : rules) {
                if (!category.BASE.equals((Object)rule.getKey().m_46332_())) continue;
                GameRules.Value testValue = rule.getValue().m_46352_();
                if (testValue instanceof GameRules.BooleanValue) {
                    this.defineFor(rule.getKey(), ((GameRules.BooleanValue)testValue).m_46223_());
                    continue;
                }
                if (testValue instanceof GameRules.IntegerValue) {
                    this.defineFor(rule.getKey(), ((GameRules.IntegerValue)testValue).m_46288_());
                    continue;
                }
                Crust.LOG.warn("Skipping undefined game rule type {}:'{}' with value '{}'", (Object)category.name().toLowerCase(), (Object)rule.getKey().m_46328_(), (Object)testValue);
            }
        }

        private void defineFor(GameRules.Key<GameRules.BooleanValue> gameRule, boolean defaultValue) {
            String id = ConfigUtil.camelCaseToLowerUnderscore(gameRule.m_46328_());
            BooleanField wrappedField = new BooleanField(id, defaultValue, (String[])null);
            this.SPEC.define(new InjectionWrapperField<BooleanField>(wrappedField, wrapped -> {
                if (CrustConfig.DEFAULT_GAME_RULES.enabled.get()) {
                    GameRules.f_46129_.put(gameRule, GameRules.BooleanValue.m_46250_((boolean)wrapped.get()));
                }
            }));
        }

        private void defineFor(GameRules.Key<GameRules.IntegerValue> gameRule, int defaultValue) {
            String id = ConfigUtil.camelCaseToLowerUnderscore(gameRule.m_46328_());
            IntField wrappedField = new IntField(id, defaultValue, IntField.Range.ANY, (String[])null);
            this.SPEC.define(new InjectionWrapperField<IntField>(wrappedField, wrapped -> {
                if (CrustConfig.DEFAULT_GAME_RULES.enabled.get()) {
                    GameRules.f_46129_.put(gameRule, GameRules.IntegerValue.m_46312_((int)wrapped.get()));
                }
            }));
        }
    }
}

