/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.config;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.api.config.common.field.ScaledDoubleField;

public class CrustModesConfigFile
extends AbstractConfigFile {
    public final General GENERAL = new General(this);
    public final Magnet MAGNET = new Magnet(this);
    public final Speed SPEED = new Speed(this);

    CrustModesConfigFile(ConfigManager cfgManager, String cfgName) {
        super(cfgManager, cfgName, "This config contains options to control the 'modes' added by Crust. Some examples of Crust modes are magnet mode, super speed mode, and undying mode.", "", "This config is for server-side settings. Client preferences are requested by using /crustmode or Crust's extra inventory buttons (client_extra_inv_buttons.toml).");
    }

    public static class General
    extends AbstractConfigCategory<CrustModesConfigFile> {
        public final IntField magnetOpLevel;
        public final IntField undyingOpLevel;
        public final IntField unbreakingOpLevel;
        public final IntField uneatingOpLevel;
        public final IntField visionOpLevel;
        public final IntField speedOpLevel;
        public final IntField noPickupOpLevel;
        public final DoubleField magnetDefault;
        public final BooleanField undyingDefault;
        public final BooleanField unbreakingDefault;
        public final IntField uneatingDefault;
        public final BooleanField visionDefault;
        public final DoubleField speedDefault;
        public final BooleanField noPickupDefault;

        General(CrustModesConfigFile parent) {
            super(parent, "general", "Options that apply to the 'modes' added by Crust, in general.");
            this.SPEC.increaseIndent();
            this.SPEC.subcategory("op_level", "The op levels (aka permission levels) required to enable/disable Crust's various modes. You can disable any mode by setting this level very high (e.g., 5).", "Vanilla op levels used are:", "  0 - Chat/whispers, Access to limited info", "  1 - Can bypass spawn protection", "  2 - Can use cheats, Access to info that can be used to cheat", "  3 - Can ban/whitelist players, 'Moderator'", "  4 - All permissions, Server management", RestartNote.WORLD.COMMENT);
            this.magnetOpLevel = this.SPEC.define(new IntField("op_level.magnet", 0, IntField.Range.ANY, new String[0]));
            this.undyingOpLevel = this.SPEC.define(new IntField("op_level.undying", 2, IntField.Range.ANY, new String[0]));
            this.unbreakingOpLevel = this.SPEC.define(new IntField("op_level.unbreaking", 2, IntField.Range.ANY, new String[0]));
            this.uneatingOpLevel = this.SPEC.define(new IntField("op_level.uneating", 2, IntField.Range.ANY, new String[0]));
            this.visionOpLevel = this.SPEC.define(new IntField("op_level.super_vision", 2, IntField.Range.ANY, new String[0]));
            this.speedOpLevel = this.SPEC.define(new IntField("op_level.super_speed", 2, IntField.Range.ANY, new String[0]));
            this.noPickupOpLevel = this.SPEC.define(new IntField("op_level.destroy_on_pickup", 2, IntField.Range.ANY, new String[0]));
            this.SPEC.subcategory("default", "The default settings for Crust's various modes initially applied to players. Note that these mode settings will be applied regardless of op level; if the player does not have permission to enable/disable the mode, they will be 'stuck' with whatever is assigned here.");
            this.magnetDefault = this.SPEC.define(new DoubleField("default.magnet", 0.0, DoubleField.Range.NON_NEGATIVE, "The maximum range (blocks) for magnet mode. If 0, magnet mode will be off by default."));
            this.undyingDefault = this.SPEC.define(new BooleanField("default.undying", false, new String[0]));
            this.unbreakingDefault = this.SPEC.define(new BooleanField("default.unbreaking", false, new String[0]));
            this.uneatingDefault = this.SPEC.define(new IntField("default.uneating", 0, 0, 20, "When dropping below this food level (half-drumsticks), uneating mode restores hunger. If 0, uneating mode will be off by default."));
            this.visionDefault = this.SPEC.define(new BooleanField("default.super_vision", false, new String[0]));
            this.speedDefault = this.SPEC.define(new DoubleField("default.super_speed", 1.0, 1.0, Double.POSITIVE_INFINITY, "The speed multiplier applied while sprinting. If 1, super speed mode will be off by default."));
            this.noPickupDefault = this.SPEC.define(new BooleanField("default.destroy_on_pickup", false, new String[0]));
            this.SPEC.decreaseIndent();
        }
    }

    public static class Magnet
    extends AbstractConfigCategory<CrustModesConfigFile> {
        public final DoubleField maxRangeLimit;
        public final DoubleField maxSpeed;
        public final IntField delay;

        Magnet(CrustModesConfigFile parent) {
            super(parent, "magnet_mode", "Options that apply to Crust's magnet mode.");
            this.maxRangeLimit = this.SPEC.define(new DoubleField("max_range_limit", 10.0, DoubleField.Range.NON_NEGATIVE, "The highest maximum range (blocks) allowed for magnet mode. Max range is a client preference."));
            this.maxSpeed = this.SPEC.define(new ScaledDoubleField.Rate("max_speed", 10.0, DoubleField.Range.NON_NEGATIVE, "The maximum speed (blocks/sec) for items pulled by magnet mode. Speed is higher the closer the item is to the player, scaling down to 0 m/s at the player's max range."));
            this.delay = this.SPEC.define(new IntField("delay", 40, IntField.Range.NON_NEGATIVE, "The time delay (ticks) before freshly dropped items are pulled by magnet mode.", "Setting this to a low value will cause items to fly around your face until their pickup delay expires. The default prevents face-flying for all vanilla drops, but many drops only have a pickup delay of 10."));
        }
    }

    public static class Speed
    extends AbstractConfigCategory<CrustModesConfigFile> {
        public final DoubleField speedLimit;

        Speed(CrustModesConfigFile parent) {
            super(parent, "super_speed_mode", "Options that apply to Crust's super-speed mode.");
            this.speedLimit = this.SPEC.define(new DoubleField("speed_limit", 12.0, 1.0, Double.POSITIVE_INFINITY, "The highest maximum speed multiplier allowed for super-speed mode. Actual speed is a client preference.", "Warning: Very large speed multipliers might break the game's physics."));
        }
    }
}

