/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.command.impl;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fathertoast.crust.api.portal.PortalBuilder;
import fathertoast.crust.common.portal.CrustPortals;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PortalTypeArgument
implements ArgumentType<PortalBuilder> {
    public static final SimpleCommandExceptionType INVALID_PORTAL_TYPE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.crustportal.portaltype.failure"));

    public static PortalTypeArgument portalType() {
        return new PortalTypeArgument();
    }

    public static PortalBuilder getPortalType(CommandContext<CommandSourceStack> context, String name) {
        return (PortalBuilder)context.getArgument(name, PortalBuilder.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestions) {
        StringReader reader = new StringReader(suggestions.getInput());
        reader.setCursor(suggestions.getStart());
        for (PortalBuilder builder : CrustPortals.PORTAL_REGISTRY.get().getValues()) {
            suggestions.suggest(CrustPortals.PORTAL_REGISTRY.get().getKey((Object)builder).toString());
        }
        return suggestions.buildFuture();
    }

    public PortalBuilder parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        PortalBuilder portalBuilder = (PortalBuilder)CrustPortals.PORTAL_REGISTRY.get().getValue(resourceLocation);
        if (portalBuilder == null) {
            throw INVALID_PORTAL_TYPE.create();
        }
        return portalBuilder;
    }
}

