/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fathertoast.crust.common.command.impl.CrustCleanCommand;
import fathertoast.crust.common.command.impl.CrustModeCommand;
import fathertoast.crust.common.command.impl.CrustPortalCommand;
import fathertoast.crust.common.command.impl.CrustRecoverCommand;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crust")
public class CommandUtil {
    public static final byte PERMISSION_NONE = 0;
    public static final byte PERMISSION_TRUSTED = 1;
    public static final byte PERMISSION_CHEAT = 2;
    public static final byte PERMISSION_MODERATE = 3;
    public static final byte PERMISSION_SERVER_OP = 4;

    @SubscribeEvent
    static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CrustCleanCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CrustModeCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CrustPortalCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CrustRecoverCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    public static void sendSuccess(CommandSourceStack source, String event, Object ... args) {
        source.m_288197_(() -> Component.m_237110_((String)("commands.crust" + event + ".success"), (Object[])args), true);
    }

    public static void sendFailure(CommandSourceStack source, String event, Object ... args) {
        source.m_81352_((Component)Component.m_237110_((String)("commands.crust" + event + ".failure"), (Object[])args));
    }

    public static String toString(Enum<?> e) {
        return e.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(Enum<?> arg) {
        return CommandUtil.literal(CommandUtil.toString(arg));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String arg) {
        return Commands.m_82127_((String)arg);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String arg, ArgumentType<T> t) {
        return Commands.m_82129_((String)arg, t);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> argumentTarget(String arg) {
        return CommandUtil.argument(arg, EntityArgument.m_91449_());
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> argumentTargets(String arg) {
        return CommandUtil.argument(arg, EntityArgument.m_91460_());
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> argumentPlayer(String arg) {
        return CommandUtil.argument(arg, EntityArgument.m_91466_());
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> argumentPlayers(String arg) {
        return CommandUtil.argument(arg, EntityArgument.m_91470_());
    }

    public static boolean canCheat(CommandSourceStack source) {
        return source.m_6761_(2);
    }

    public static Entity target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ((CommandSourceStack)context.getSource()).m_81374_();
    }

    public static Entity target(CommandContext<CommandSourceStack> context, String arg) throws CommandSyntaxException {
        return EntityArgument.m_91452_(context, (String)arg);
    }

    public static Collection<? extends Entity> targets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ImmutableList.of((Object)CommandUtil.target(context));
    }

    public static Collection<? extends Entity> targets(CommandContext<CommandSourceStack> context, String arg) throws CommandSyntaxException {
        return EntityArgument.m_91461_(context, (String)arg);
    }

    public static ServerPlayer player(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ((CommandSourceStack)context.getSource()).m_81375_();
    }

    public static ServerPlayer player(CommandContext<CommandSourceStack> context, String arg) throws CommandSyntaxException {
        return EntityArgument.m_91474_(context, (String)arg);
    }

    public static Collection<ServerPlayer> players(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ImmutableList.of((Object)CommandUtil.player(context));
    }

    public static Collection<ServerPlayer> players(CommandContext<CommandSourceStack> context, String arg) throws CommandSyntaxException {
        return EntityArgument.m_91477_(context, (String)arg);
    }
}

