/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client.mode;

import fathertoast.crust.common.mode.CrustModeEvents;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.CrustModesData;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crust")
public class CrustModeClientEvents {
    private static Float originalStepHeight;
    private static Float originalFlySpeed;

    @SubscribeEvent
    static void onFogDensity(ViewportEvent.RenderFog event) {
        if (CrustModes.SUPER_VISION.enabled((Player)Minecraft.m_91087_().f_91074_)) {
            float reallyFarPlane = 1024.0f;
            if (event.getFarPlaneDistance() < reallyFarPlane) {
                event.setFarPlaneDistance(reallyFarPlane);
            }
            if (event.getNearPlaneDistance() < reallyFarPlane) {
                event.setNearPlaneDistance(reallyFarPlane);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91073_ != null) {
            CrustModeEvents.onWorldTickStart((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    @SubscribeEvent
    static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        Player player = event.player;
        CrustModesData playerModes = CrustModesData.of(player);
        int clock4 = player.f_19797_ & 3;
        if (clock4 == 3) {
            if (player.m_20142_() && playerModes.enabled(CrustModes.SUPER_SPEED)) {
                if (originalStepHeight == null) {
                    originalStepHeight = Float.valueOf(player.m_274421_());
                }
                player.m_274367_(Math.max(originalStepHeight.floatValue(), 1.0f));
                if (player.m_150110_().f_35935_) {
                    if (originalFlySpeed == null) {
                        originalFlySpeed = Float.valueOf(player.m_150110_().m_35942_());
                    }
                    player.m_150110_().m_35943_(originalFlySpeed.floatValue() * playerModes.get(CrustModes.SUPER_SPEED).floatValue());
                }
            } else {
                if (originalStepHeight != null) {
                    player.m_274367_(originalStepHeight.floatValue());
                    originalStepHeight = null;
                }
                if (originalFlySpeed != null) {
                    player.m_150110_().m_35943_(originalFlySpeed.floatValue());
                    originalFlySpeed = null;
                }
            }
        }
    }
}

