/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client.config;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.EnumField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.value.CrustAnchor;
import net.minecraftforge.fml.ModList;

public class CfgEditorCrustConfigFile
extends AbstractConfigFile {
    public final Button MAIN_BUTTON;
    public final Button PAUSE_BUTTON;

    public CfgEditorCrustConfigFile(ConfigManager cfgManager, String cfgName) {
        super(cfgManager, cfgName, "In-game config editor client preferences.");
        boolean buttonConflict = ModList.get().isLoaded("quark");
        this.MAIN_BUTTON = new Button(this, "main_menu_button", "Options to modify the in-game config editor button on the main menu.", -56, buttonConflict, "Set this to false to hide the config editor button on the main menu.");
        this.PAUSE_BUTTON = new Button(this, "pause_menu_button", "Options to modify the in-game config editor button on the pause menu.", -44, buttonConflict, "Set this to false to hide the in-game config editor button.", "You may assign a hotkey to the editor in your options, whether or not you choose to display a button.");
    }

    public static class Button
    extends AbstractConfigCategory<CfgEditorCrustConfigFile> {
        public final BooleanField enabled;
        public final EnumField<CrustAnchor> anchorY;
        public final EnumField<CrustAnchor> anchorX;
        public final IntField offsetY;
        public final IntField offsetX;

        Button(CfgEditorCrustConfigFile parent, String category, String categoryDescription, int offV, boolean buttonConflict, String ... enabledComment) {
            super(parent, category, categoryDescription);
            this.enabled = this.SPEC.define(new BooleanField("enabled", true, enabledComment));
            this.SPEC.newLine();
            this.anchorY = this.SPEC.define(new EnumField("anchor.vertical", (Enum)CrustAnchor.BOTTOM, (Enum[])CrustAnchor.VERTICAL_GUI, new String[]{"The anchor position for the config editor button. That is, where it should be positioned relative to the screen or vanilla menu buttons."}));
            this.anchorX = this.SPEC.define(new EnumField("anchor.horizontal", (Enum)(buttonConflict ? CrustAnchor.RIGHT : CrustAnchor.LEFT), (Enum[])CrustAnchor.HORIZONTAL_GUI, (String[])null));
            this.SPEC.newLine();
            this.offsetY = this.SPEC.define(new IntField("offset.vertical", offV, IntField.Range.ANY, "The position offset for the config editor button from the anchor position, in GUI pixels. Negative values move the button toward the top/left, positive move it toward the bottom/right."));
            this.offsetX = this.SPEC.define(new IntField("offset.horizontal", buttonConflict ? 4 : -4, IntField.Range.ANY, (String[])null));
        }
    }
}

