/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client.button;

import com.mojang.blaze3d.systems.RenderSystem;
import fathertoast.crust.api.lib.CrustMath;
import fathertoast.crust.client.ClientRegister;
import fathertoast.crust.client.button.ButtonInfo;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ExtraInventoryButton
extends Button {
    public static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crust", (String)"textures/button.png");
    public static final ResourceLocation BUTTON_TEXTURE_ON = ResourceLocation.fromNamespaceAndPath((String)"crust", (String)"textures/button_on.png");
    public static final int ICON_SIZE = 9;
    public static final int ICON_BORDER = 3;
    public static final int BUTTON_SIZE = 15;
    public static final int BUTTON_PADDING = 1;
    public static final int BUTTON_SPACING = 16;
    public static final int TEXT_X = Mth.m_14167_((float)7.5f);
    public static final int TEXT_Y = Mth.m_14167_((float)3.5f);
    private final AbstractContainerScreen<?> PARENT;
    private final boolean HAS_RECIPE_BOOK;
    private final ButtonInfo INFO;

    public ExtraInventoryButton(AbstractContainerScreen<?> screen, int leftPos, int topPos, ButtonInfo info) {
        super(leftPos, topPos, 15, 15, (Component)Component.m_237113_((String)info.TEXT), info.ON_PRESS, Supplier::get);
        this.m_257544_(ExtraInventoryButton.createButtonTooltip(info.TOOLTIP));
        this.PARENT = screen;
        this.HAS_RECIPE_BOOK = screen instanceof RecipeUpdateListener;
        this.INFO = info;
    }

    public void m_5691_() {
        super.m_5691_();
        this.PARENT.f_97719_ = true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (ClientRegister.EXTRA_INV_BUTTONS.GENERAL.hideForRecipeBook.get() && this.HAS_RECIPE_BOOK) {
            this.f_93624_ = !((RecipeUpdateListener)this.PARENT).m_5564_().m_100385_();
        }
        this.f_93623_ = this.INFO.canBeActive() && (!ClientRegister.EXTRA_INV_BUTTONS.GENERAL.disableInvalid.get() || this.INFO.canEnable());
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float colorFac;
        Minecraft mc = Minecraft.m_91087_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(0.0, 0.0, 31.0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        graphics.m_280163_(this.INFO.isToggledOn() ? BUTTON_TEXTURE_ON : BUTTON_TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, (float)this.m_274533_(), 15, 15, 15, 45);
        float f = colorFac = this.f_93623_ ? 1.0f : 0.666f;
        if (this.INFO.ICON == null) {
            RenderSystem.setShaderColor((float)colorFac, (float)colorFac, (float)colorFac, (float)this.f_93625_);
            graphics.m_280653_(mc.f_91062_, this.m_6035_(), this.m_252754_() + TEXT_X, this.m_252907_() + TEXT_Y, this.INFO.COLOR | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        } else {
            RenderSystem.setShaderColor((float)(CrustMath.getRed(this.INFO.COLOR) * colorFac), (float)(CrustMath.getGreen(this.INFO.COLOR) * colorFac), (float)(CrustMath.getBlue(this.INFO.COLOR) * colorFac), (float)this.f_93625_);
            graphics.m_280163_(this.INFO.ICON, this.m_252754_() + 3, this.m_252907_() + 3, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        graphics.m_280168_().m_85849_();
    }

    public int m_274533_() {
        return 15 * (!this.f_93623_ ? 0 : (this.m_274382_() ? 2 : 1));
    }

    public static Tooltip createButtonTooltip(String tooltip) {
        return Tooltip.m_257550_((Component)Component.m_237115_((String)tooltip));
    }
}

