/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client.button;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import fathertoast.crust.api.lib.CrustObjects;
import fathertoast.crust.client.ClientRegister;
import fathertoast.crust.client.config.ExtraInvButtonsCrustConfigFile;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.CrustModesData;
import fathertoast.crust.common.mode.type.CrustMode;
import fathertoast.crust.common.portal.CrustPortals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ButtonInfo {
    public static final String ICON_PATH = "textures/icon/";
    private static final Map<String, ButtonInfo> BUTTON_REGISTRY = new HashMap<String, ButtonInfo>();
    private static final ArrayList<String> BUILT_INS = new ArrayList();
    public static final ButtonInfo FULL_HEAL = ButtonInfo.builtIn(new ButtonInfo("fullHeal", "instant_health.png", "crustrecover"));
    public static final ButtonInfo CLEAR_EFFECTS = ButtonInfo.builtIn(new ButtonInfo("clearEffects", "milk.png", "effect clear").condition(() -> !ButtonInfo.player().m_21221_().isEmpty()));
    public static final ButtonInfo DESTROY_POINTER_ITEM = ButtonInfo.builtIn(new ButtonInfo("destroyOnPointer", "fire.png", ButtonInfo::destroyOnPointer, "crustclean pointer").condition(() -> !ButtonInfo.player().f_36095_.m_142621_().m_41619_()));
    public static final ButtonInfo KILL_ALL = ButtonInfo.builtIn(new ButtonInfo("killAll", "creeper_slash.png", "kill @e[type=!player]"));
    public static final ButtonInfo NETHER_PORTAL = ButtonInfo.builtIn(new ButtonInfo("netherPortal", "portal_nether.png", "crustportal " + CrustPortals.NETHER_PORTAL).condition(() -> CrustObjects.netherPortal().isValidDimension((Level)ButtonInfo.world())));
    public static final ButtonInfo END_PORTAL = ButtonInfo.builtIn(new ButtonInfo("endPortal", "portal_end.png", "crustportal " + CrustPortals.END_PORTAL).condition(() -> CrustObjects.endPortal().isValidDimension((Level)ButtonInfo.world())));
    public static final ButtonInfo DAY = ButtonInfo.builtIn(new ButtonInfo("day", "day.png", "time set day"));
    public static final ButtonInfo NIGHT = ButtonInfo.builtIn(new ButtonInfo("night", "night.png", "time set night"));
    public static final ButtonInfo TOGGLE_DAY = ButtonInfo.builtIn(new ButtonInfo("toggleDay", "day_night.png", ButtonInfo::toggleDay, "time set day", "time set night"));
    public static final ButtonInfo WEATHER_CLEAR = ButtonInfo.builtIn(new ButtonInfo("weatherClear", "rain_slash.png", button -> ButtonInfo.cmd(Command.clear()), "weather clear"));
    public static final ButtonInfo WEATHER_RAIN = ButtonInfo.builtIn(new ButtonInfo("weatherRain", "rain.png", button -> ButtonInfo.cmd(Command.rain()), "weather rain"));
    public static final ButtonInfo WEATHER_STORM = ButtonInfo.builtIn(new ButtonInfo("weatherStorm", "thunder.png", button -> ButtonInfo.cmd(Command.thunder()), "weather thunder"));
    public static final ButtonInfo TOGGLE_RAIN = ButtonInfo.builtIn(new ButtonInfo("toggleRain", "weather_toggle.png", ButtonInfo::toggleRain, "weather clear", "weather rain"));
    public static final ButtonInfo GAME_MODE = ButtonInfo.builtIn(new ButtonInfo("gameMode", "grass.png", ButtonInfo::gameMode, "gamemode survival", "gamemode creative").toggle(() -> ButtonInfo.player().m_7500_()));
    public static final ButtonInfo MAGNET_MODE = ButtonInfo.builtIn(new ButtonInfo("magnetMode", "magnet.png", ButtonInfo::magnetMode, Command.forMode(CrustModes.MAGNET)).toggle(() -> ButtonInfo.modeEnabled(CrustModes.MAGNET)));
    public static final ButtonInfo GOD_MODE = ButtonInfo.builtIn(new ButtonInfo("godMode", "undying.png", ButtonInfo::godMode, new String[0]).toggle(() -> {
        ExtraInvButtonsCrustConfigFile.BuiltInButtons buttonCfg = ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS;
        CrustModesData playerModes = CrustModesData.of((Player)ButtonInfo.player());
        return !(buttonCfg.godModeUndying.get() && !playerModes.enabled(CrustModes.UNDYING) || buttonCfg.godModeUnbreaking.get() && !playerModes.enabled(CrustModes.UNBREAKING) || buttonCfg.godModeUneating.get() > 0 && !playerModes.enabled(CrustModes.UNEATING));
    }));
    public static final ButtonInfo SUPER_VISION_MODE = ButtonInfo.builtIn(new ButtonInfo("superVisionMode", "night_vision.png", ButtonInfo::superVisionMode, Command.forMode(CrustModes.SUPER_VISION)).toggle(() -> ButtonInfo.modeEnabled(CrustModes.SUPER_VISION)));
    public static final ButtonInfo SUPER_SPEED_MODE = ButtonInfo.builtIn(new ButtonInfo("superSpeedMode", "swiftness.png", ButtonInfo::superSpeedMode, Command.forMode(CrustModes.SUPER_SPEED)).toggle(() -> ButtonInfo.modeEnabled(CrustModes.SUPER_SPEED)));
    public static final ButtonInfo NO_PICKUP_MODE = ButtonInfo.builtIn(new ButtonInfo("noPickupMode", "weakness.png", ButtonInfo::noPickupMode, Command.forMode(CrustModes.DESTROY_ON_PICKUP)).toggle(() -> ButtonInfo.modeEnabled(CrustModes.DESTROY_ON_PICKUP)));
    public final String ID;
    public final String TOOLTIP;
    public final String TEXT;
    public final ResourceLocation ICON;
    public final int COLOR;
    public final Button.OnPress ON_PRESS;
    protected final List<String> COMMANDS = new ArrayList<String>();
    private Supplier<Boolean> enabled;
    private boolean active;
    private Supplier<Boolean> toggledOn;

    public static List<String> builtInIds() {
        return BUILT_INS;
    }

    @Nullable
    public static ButtonInfo get(String id) {
        return BUTTON_REGISTRY.get(id);
    }

    public static ButtonInfo getCustom(int index) {
        return Objects.requireNonNull(ButtonInfo.get(ButtonInfo.customId(index)));
    }

    public static String customId(int index) {
        return "custom" + (index + 1);
    }

    public static void loadCustomButton(String id, ExtraInvButtonsCrustConfigFile.CustomButton buttonCfg) {
        BUTTON_REGISTRY.put(id, new ButtonInfo(id, (String)buttonCfg.tooltip.get(), (String)buttonCfg.icon.get(), buttonCfg.iconColor.get(), (List)buttonCfg.commands.get()));
    }

    public static void updateGodModePerms(ExtraInvButtonsCrustConfigFile.BuiltInButtons buttonCfg) {
        ButtonInfo godModeButton = ButtonInfo.get("godMode");
        if (godModeButton == null) {
            return;
        }
        godModeButton.COMMANDS.clear();
        if (buttonCfg.godModeUndying.get()) {
            godModeButton.COMMANDS.add(Command.forMode(CrustModes.UNDYING));
        }
        if (buttonCfg.godModeUnbreaking.get()) {
            godModeButton.COMMANDS.add(Command.forMode(CrustModes.UNBREAKING));
        }
        if (buttonCfg.godModeUneating.get() > 0) {
            godModeButton.COMMANDS.add(Command.forMode(CrustModes.UNEATING));
        }
    }

    private static ButtonInfo builtIn(ButtonInfo info) {
        BUTTON_REGISTRY.put(info.ID, info);
        BUILT_INS.add(info.ID);
        return info;
    }

    private static String toLangKey(String id) {
        return "inventory.buttons." + id.toLowerCase(Locale.ROOT) + ".tooltip";
    }

    public ButtonInfo(String id, String tooltip, String display, int color, Button.OnPress onPress) {
        this.ID = id;
        this.TOOLTIP = tooltip;
        if (display.endsWith(".png")) {
            this.TEXT = "";
            this.ICON = ResourceLocation.fromNamespaceAndPath((String)"crust", (String)(ICON_PATH + display));
        } else {
            this.TEXT = display;
            this.ICON = null;
        }
        this.COLOR = color;
        this.ON_PRESS = onPress;
    }

    public ButtonInfo(String id, String display, Button.OnPress onPress, String ... commands) {
        this(id, ButtonInfo.toLangKey(id), display, 0xFFFFFF, onPress);
        this.COMMANDS.addAll(Arrays.asList(commands));
    }

    public ButtonInfo(String id, String display, String command) {
        this(id, ButtonInfo.toLangKey(id), display, 0xFFFFFF, new ButtonPressCommandChain(Collections.singletonList(command)));
        this.COMMANDS.add(command);
    }

    public ButtonInfo(String id, String tooltip, String display, int color, List<String> commands) {
        this(id, tooltip, display, color, new ButtonPressCommandChain(commands));
        this.COMMANDS.addAll(commands);
    }

    protected ButtonInfo condition(Supplier<Boolean> canEnable) {
        this.enabled = canEnable;
        return this;
    }

    protected ButtonInfo toggle(Supplier<Boolean> isToggledOn) {
        this.toggledOn = isToggledOn;
        return this;
    }

    public boolean isUsable() {
        if (this.COMMANDS.isEmpty()) {
            return false;
        }
        for (String command : this.COMMANDS) {
            if (ButtonInfo.canUseCommand(command)) continue;
            return false;
        }
        return true;
    }

    public boolean canEnable() {
        return this.enabled == null || this.enabled.get() != false;
    }

    public void setCanBeActive(boolean value) {
        this.active = value;
    }

    public boolean canBeActive() {
        return this.active;
    }

    public boolean isToggledOn() {
        return this.toggledOn != null && this.toggledOn.get() != false;
    }

    private static void destroyOnPointer(@Nullable Button button) {
        if (Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            ButtonInfo.player().f_36095_.m_142503_(ItemStack.f_41583_);
        } else {
            ButtonInfo.cmd("crustclean pointer");
        }
    }

    private static void toggleDay(@Nullable Button button) {
        int dayTime = (int)(ButtonInfo.world().m_46468_() % 24000L);
        ButtonInfo.cmd(dayTime < 1000 || dayTime >= 13000 ? "time set day" : "time set night");
    }

    private static void toggleRain(@Nullable Button button) {
        ButtonInfo.cmd(ButtonInfo.world().m_6106_().m_6533_() || ButtonInfo.world().m_6106_().m_6534_() ? Command.clear() : Command.rain());
    }

    private static void gameMode(@Nullable Button button) {
        ButtonInfo.cmd(GAME_MODE.isToggledOn() ? "gamemode survival" : "gamemode creative");
    }

    private static void magnetMode(@Nullable Button button) {
        ButtonInfo.toggleCrustMode(CrustModes.MAGNET, Float.valueOf(ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS.magnetMaxRange.getFloat()));
    }

    private static void godMode(@Nullable Button button) {
        ExtraInvButtonsCrustConfigFile.BuiltInButtons buttonCfg = ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS;
        boolean toggleOff = GOD_MODE.isToggledOn();
        if (buttonCfg.godModeUndying.get()) {
            ButtonInfo.cmd(Command.forMode(CrustModes.UNDYING, toggleOff ? null : Byte.valueOf((byte)1)));
        }
        if (buttonCfg.godModeUnbreaking.get()) {
            ButtonInfo.cmd(Command.forMode(CrustModes.UNBREAKING, toggleOff ? null : Byte.valueOf((byte)1)));
        }
        if (buttonCfg.godModeUneating.get() > 0) {
            ButtonInfo.cmd(Command.forMode(CrustModes.UNEATING, toggleOff ? null : Byte.valueOf(buttonCfg.godModeUneating.getByte())));
        }
    }

    private static void superVisionMode(@Nullable Button button) {
        ButtonInfo.toggleCrustMode(CrustModes.SUPER_VISION, (byte)1);
    }

    private static void superSpeedMode(@Nullable Button button) {
        ButtonInfo.toggleCrustMode(CrustModes.SUPER_SPEED, Float.valueOf(ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS.superSpeedMulti.getFloat()));
    }

    private static void noPickupMode(@Nullable Button button) {
        ButtonInfo.toggleCrustMode(CrustModes.DESTROY_ON_PICKUP, (byte)1);
    }

    private static <T> void toggleCrustMode(CrustMode<T> mode, T value) {
        ButtonInfo.cmd(Command.forMode(mode, ButtonInfo.modeEnabled(mode) ? null : (Object)value));
    }

    private static void cmd(String command) {
        ButtonInfo.player().f_108617_.m_246623_(command);
    }

    private static boolean modeEnabled(CrustMode<?> mode) {
        return CrustModesData.of((Player)ButtonInfo.player()).enabled(mode);
    }

    private static LocalPlayer player() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
    }

    private static ClientLevel world() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    @Nullable
    private static ParseResults<SharedSuggestionProvider> parseCommand(String command) {
        StringReader reader = new StringReader(StringUtils.normalizeSpace((String)command));
        if (reader.canRead() && reader.peek() == '/') {
            reader.skip();
        }
        ClientPacketListener connection = ButtonInfo.player().f_108617_;
        return connection.m_105146_().parse(reader, (Object)connection.m_105137_());
    }

    private static boolean canUseCommand(String command) {
        ParseResults<SharedSuggestionProvider> parse = ButtonInfo.parseCommand(command);
        return parse != null && !parse.getReader().canRead();
    }

    static {
        BUILT_INS.trimToSize();
    }

    private static class Command {
        static final String TIME_DAY = "time set day";
        static final String TIME_NIGHT = "time set night";
        static final String WEATHER_CLEAR = "weather clear";
        static final String WEATHER_RAIN = "weather rain";
        static final String WEATHER_THUNDER = "weather thunder";
        static final String MODE_SURVIVAL = "gamemode survival";
        static final String MODE_CREATIVE = "gamemode creative";
        static final String CLEAN_POINTER = "crustclean pointer";

        private Command() {
        }

        static String clear() {
            return "weather clear " + ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS.weatherDuration.get();
        }

        static String rain() {
            return "weather rain " + ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS.weatherDuration.get();
        }

        static String thunder() {
            return "weather thunder " + ClientRegister.EXTRA_INV_BUTTONS.BUILT_IN_BUTTONS.weatherDuration.get();
        }

        static <T> String forMode(CrustMode<T> mode) {
            return Command.forMode(mode, null);
        }

        static <T> String forMode(CrustMode<T> mode, @Nullable T value) {
            return "crustmode " + mode.ID + " " + (value == null ? "disable" : Command.toCmd(value));
        }

        private static String toCmd(Object value) {
            if (value instanceof Float) {
                return String.format(Locale.ROOT, "%f", (Float)value);
            }
            if (value instanceof Double) {
                return String.format(Locale.ROOT, "%f", (Double)value);
            }
            return value.toString();
        }
    }

    private static class ButtonPressCommandChain
    implements Button.OnPress {
        private final List<String> COMMANDS;

        ButtonPressCommandChain(List<String> commands) {
            this.COMMANDS = commands;
        }

        public void m_93750_(@Nullable Button button) {
            for (String command : this.COMMANDS) {
                ButtonInfo.cmd(command);
            }
        }
    }
}

