/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client;

import fathertoast.crust.api.config.client.gui.screen.CrustConfigSelectScreen;
import fathertoast.crust.api.config.common.value.CrustAnchor;
import fathertoast.crust.client.ClientRegister;
import fathertoast.crust.client.button.ButtonInfo;
import fathertoast.crust.client.button.ExtraInventoryButton;
import fathertoast.crust.client.button.ExtraMenuButton;
import fathertoast.crust.client.config.CfgEditorCrustConfigFile;
import fathertoast.crust.client.config.ExtraInvButtonsCrustConfigFile;
import fathertoast.crust.common.core.Crust;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crust")
public class ScreenEvents {
    @SubscribeEvent
    static void onGuiInit(ScreenEvent.Init.Post event) {
        Screen screen;
        if (ClientRegister.EXTRA_INV_BUTTONS.GENERAL.enabled.get() && event.getScreen() instanceof AbstractContainerScreen) {
            boolean creative;
            MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
            boolean bl = creative = gameMode != null && gameMode.m_105290_();
            if (!(creative && event.getScreen() instanceof InventoryScreen || !creative && event.getScreen() instanceof CreativeModeInventoryScreen)) {
                ScreenEvents.addExtraInventoryButtons((ScreenEvent.Init)event, (AbstractContainerScreen)event.getScreen());
            }
        } else if (ClientRegister.CONFIG_EDITOR.PAUSE_BUTTON.enabled.get() && (screen = event.getScreen()) instanceof PauseScreen) {
            PauseScreen pauseScreen = (PauseScreen)screen;
            ScreenEvents.addExtraPauseMenuButtons((ScreenEvent.Init)event, pauseScreen);
        } else if (ClientRegister.CONFIG_EDITOR.MAIN_BUTTON.enabled.get() && (screen = event.getScreen()) instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            ScreenEvents.addExtraMainMenuButtons((ScreenEvent.Init)event, titleScreen);
        }
    }

    private static void addExtraInventoryButtons(ScreenEvent.Init event, AbstractContainerScreen<?> screen) {
        Minecraft mc = screen.getMinecraft();
        ExtraInvButtonsCrustConfigFile.General config = ClientRegister.EXTRA_INV_BUTTONS.GENERAL;
        ArrayList<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
        for (String buttonId : (List)config.buttons.get()) {
            ButtonInfo button = ButtonInfo.get(buttonId);
            if (button != null) {
                if (button.isUsable()) {
                    button.setCanBeActive(true);
                } else {
                    button.setCanBeActive(false);
                    if (config.hideUnusable.get()) continue;
                }
                buttons.add(button);
                continue;
            }
            Crust.LOG.warn("Skipping button with invalid id \"{}\"!", (Object)buttonId);
        }
        if (buttons.isEmpty()) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int buttonCount = buttons.size();
        int buttonsPerRow = config.buttonsPerRow.get();
        int buttonRows = Mth.m_14167_((float)((float)buttonCount / (float)buttonsPerRow));
        int width = buttonsPerRow * 16 - 1;
        int height = buttonRows * 16 - 1;
        int posX = ((CrustAnchor)((Object)config.anchorX.get())).pos(screenWidth, screen.getXSize(), screen.getGuiLeft(), width) + config.offsetX.get();
        int posY = ((CrustAnchor)((Object)config.anchorY.get())).pos(screenHeight, screen.getYSize(), screen.getGuiTop(), height) + config.offsetY.get();
        for (int i = 0; i < buttonCount; ++i) {
            event.addListener((GuiEventListener)new ExtraInventoryButton(screen, posX + i % buttonsPerRow * 16, posY + i / buttonsPerRow * 16, (ButtonInfo)buttons.get(i)));
        }
    }

    private static void addExtraPauseMenuButtons(ScreenEvent.Init event, PauseScreen screen) {
        Minecraft mc = screen.getMinecraft();
        CfgEditorCrustConfigFile.Button config = ClientRegister.CONFIG_EDITOR.PAUSE_BUTTON;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int guiWidth = 204;
        int guiHeight = 140;
        int topPadding = 50;
        int posX = ((CrustAnchor)((Object)config.anchorX.get())).pos(screenWidth, guiWidth, (int)Mth.m_14179_((float)0.5f, (float)0.0f, (float)(screenWidth - guiWidth)), 20) + config.offsetX.get();
        int posY = ((CrustAnchor)((Object)config.anchorY.get())).pos(screenHeight, guiHeight, (int)Mth.m_14179_((float)0.25f, (float)0.0f, (float)(screenHeight - guiHeight - topPadding)) + topPadding, 20) + config.offsetY.get();
        event.addListener((GuiEventListener)new ExtraMenuButton(posX, posY, button -> mc.m_91152_((Screen)new CrustConfigSelectScreen((Screen)screen))));
    }

    private static void addExtraMainMenuButtons(ScreenEvent.Init event, TitleScreen screen) {
        Minecraft mc = screen.getMinecraft();
        CfgEditorCrustConfigFile.Button config = ClientRegister.CONFIG_EDITOR.MAIN_BUTTON;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int guiWidth = 200;
        int guiHeight = 104;
        int posX = ((CrustAnchor)((Object)config.anchorX.get())).pos(screenWidth, guiWidth, 20) + config.offsetX.get();
        int posY = ((CrustAnchor)((Object)config.anchorY.get())).pos(screenHeight, guiHeight, screenHeight / 4 + 48, 20) + config.offsetY.get();
        event.addListener((GuiEventListener)new ExtraMenuButton(posX, posY, button -> mc.m_91152_((Screen)new CrustConfigSelectScreen((Screen)screen))));
    }
}

