/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fathertoast.crust.api.util.IBlockEntityBBProvider;
import fathertoast.crust.api.util.IBlockEntityDebugShapeProvider;
import fathertoast.crust.api.util.IDebugShape;
import fathertoast.crust.client.ClientRegister;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        block7: {
            if (!ClientRegister.RENDER_SETTINGS.BLOCK_ENTITY_BB_RENDERING.enabled.get() || event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) break block7;
            if (!Minecraft.m_91087_().m_91290_().m_114377_() || Minecraft.m_91087_().m_91299_()) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
            VertexConsumer linesBuffer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            int chunkX = playerPos.m_123341_() >> 4;
            int chunkZ = playerPos.m_123343_() >> 4;
            int radius = Math.min(ClientRegister.RENDER_SETTINGS.BLOCK_ENTITY_BB_RENDERING.distance.get(), Minecraft.m_91087_().f_91066_.m_193772_());
            if (radius <= 1) {
                for (BlockEntity blockEntity : level.m_6325_(chunkX, chunkZ).m_62954_().values()) {
                    this.renderBoundingBoxes(blockEntity, event.getPoseStack(), event.getCamera().m_90583_(), linesBuffer);
                }
            } else {
                for (int x = chunkX - (radius - 1); x < chunkX + radius; ++x) {
                    for (int z = chunkZ - (radius - 1); z < chunkZ + radius; ++z) {
                        if (!level.m_7232_(x, z)) continue;
                        for (BlockEntity blockEntity : level.m_6325_(x, z).m_62954_().values()) {
                            this.renderBoundingBoxes(blockEntity, event.getPoseStack(), event.getCamera().m_90583_(), linesBuffer);
                        }
                    }
                }
            }
        }
    }

    private void renderBoundingBoxes(BlockEntity blockEntity, PoseStack poseStack, Vec3 cameraPos, VertexConsumer buffer) {
        if (blockEntity instanceof IBlockEntityDebugShapeProvider) {
            IBlockEntityDebugShapeProvider shapeProvider = (IBlockEntityDebugShapeProvider)blockEntity;
            List<IDebugShape> shapes = shapeProvider.getDebugShapes();
            if (shapes == null || shapes.isEmpty()) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            shapes.forEach(shape -> shape.renderShape(poseStack, blockEntity.m_58899_(), cameraPos, buffer));
            poseStack.m_85849_();
        } else if (blockEntity instanceof IBlockEntityBBProvider) {
            IBlockEntityBBProvider bbProvider = (IBlockEntityBBProvider)blockEntity;
            List<AABB> boxes = bbProvider.getBoundingBoxes();
            if (boxes == null || boxes.isEmpty()) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            for (AABB box : boxes) {
                if (box == null) continue;
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)box, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            poseStack.m_85849_();
        }
    }
}

