/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.lib;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class NBTHelper {
    public static boolean containsList(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 9);
    }

    public static boolean containsCompound(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 10);
    }

    public static boolean containsString(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 8);
    }

    public static boolean containsNumber(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 99);
    }

    public static boolean containsByteArray(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 7);
    }

    public static boolean containsIntArray(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 11);
    }

    public static boolean containsLongArray(CompoundTag tag, String name) {
        return NBTHelper.contains(tag, name, 12);
    }

    private static boolean contains(CompoundTag tag, String name, int id) {
        return tag.m_128425_(name, id);
    }

    public static CompoundTag getOrCreateCompound(CompoundTag tag, String name) {
        if (!NBTHelper.containsCompound(tag, name)) {
            tag.m_128365_(name, (Tag)new CompoundTag());
        }
        return tag.m_128469_(name);
    }

    public static CompoundTag getForgeData(Entity entity) {
        return entity.getPersistentData();
    }

    public static CompoundTag getForgeData(Entity entity, String name) {
        return NBTHelper.getOrCreateCompound(NBTHelper.getForgeData(entity), name);
    }

    public static CompoundTag getForgeData(Entity entity, String name, String subName) {
        return NBTHelper.getOrCreateCompound(NBTHelper.getOrCreateCompound(NBTHelper.getForgeData(entity), name), subName);
    }

    public static CompoundTag getPlayerData(Player player) {
        return NBTHelper.getForgeData((Entity)player, "PlayerPersisted");
    }

    public static CompoundTag getPlayerData(Player player, String name) {
        return NBTHelper.getOrCreateCompound(NBTHelper.getPlayerData(player), name);
    }

    public static CompoundTag getPlayerData(Player player, String name, String subName) {
        return NBTHelper.getOrCreateCompound(NBTHelper.getPlayerData(player, name), subName);
    }
}

