/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.lib;

import fathertoast.crust.api.lib.CrustMath;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum LevelEventHelper {
    DISPENSER_DISPENSE(1000),
    DISPENSER_FAIL(1001),
    DISPENSER_LAUNCH(1002),
    ENDER_EYE_SOUND(1003),
    FIREWORK_ROCKET_SHOOT(1004),
    IRON_DOOR_OPEN(1005),
    WOODEN_DOOR_OPEN(1006),
    WOODEN_TRAPDOOR_OPEN(1007),
    FENCE_GATE_OPEN(1008),
    IRON_DOOR_CLOSE(1011),
    WOODEN_DOOR_CLOSE(1012),
    WOODEN_TRAPDOOR_CLOSE(1013),
    FENCE_GATE_CLOSE(1014),
    IRON_TRAPDOOR_CLOSE(1036),
    IRON_TRAPDOOR_OPEN(1037),
    FIRE_EXTINGUISH(1009),
    GHAST_WARN(1015),
    GHAST_SHOOT(1016),
    ENDER_DRAGON_SHOOT(1017),
    ENDER_DRAGON_GROWL(3001),
    BLAZE_SHOOT(1018),
    PHANTOM_BITE(1039),
    ZOMBIE_ATTACK_WOODEN_DOOR(1019),
    ZOMBIE_ATTACK_IRON_DOOR(1020),
    ZOMBIE_BREAK_WOODEN_DOOR(1021),
    ZOMBIE_INFECT(1026),
    ZOMBIE_VILLAGER_CONVERTED(1027),
    ZOMBIE_CONVERTED_TO_DROWNED(1040),
    HUSK_CONVERTED_TO_ZOMBIE(1041),
    WITHER_BREAK_BLOCK(1022),
    WITHER_SHOOT(1024),
    BAT_TAKEOFF(1025),
    ANVIL_DESTROY(1029),
    ANVIL_USE(1030),
    ANVIL_LAND(1031),
    BREWING_STAND_BREW(1035),
    GRINDSTONE_USE(1042),
    BOOK_PAGE_TURN(1043),
    SMITHING_TABLE_USE(1044),
    PORTAL_TRAVEL(1032),
    CHORUS_FLOWER_GROW(1033),
    CHORUS_FLOWER_DEATH(1034),
    ENDER_EYE_PARTICLE(2003),
    SMOKE_AND_FLAME(2004),
    EXPLOSION_PARTICLE(2008),
    CLOUD_PARTICLES(2009),
    LAVA_EXTINGUISH(1501),
    REDSTONE_TORCH_BURNOUT(1502),
    END_PORTAL_FRAME_FILL(1503),
    END_PORTAL_FRAME_COMPLETED(3000);

    public static final MusicDiscEvent MUSIC_DISC;
    public static final DispenserSmokeEvent DISPENSER_SMOKE;
    public static final BoneMealEvent BONE_MEAL_USE;
    public static final BlockBreakEvent BLOCK_BREAK_FX;
    public static final ColorEvent SPLASH_POTION_FX;
    public static final ColorEvent INSTANT_SPLASH_POTION_FX;
    public static final ComposterFillEvent COMPOSTER_FILL;
    public static final OptionalSoundEvent ENDER_DRAGON_FIREBALL_HIT;
    public final int ID;

    private LevelEventHelper(int id) {
        this.ID = id;
    }

    public void play(Entity entity) {
        if (!entity.m_20067_()) {
            this.play(entity.m_9236_(), entity.m_20183_());
        }
    }

    public void play(Level level, BlockPos pos) {
        this.play(level, null, pos);
    }

    public void play(Level level, @Nullable Player player, BlockPos pos) {
        level.m_5898_(player, this.ID, pos, 0);
    }

    static {
        MUSIC_DISC = new MusicDiscEvent(1010);
        DISPENSER_SMOKE = new DispenserSmokeEvent(2000);
        BONE_MEAL_USE = new BoneMealEvent(2005);
        BLOCK_BREAK_FX = new BlockBreakEvent(2001);
        SPLASH_POTION_FX = new ColorEvent(2002);
        INSTANT_SPLASH_POTION_FX = new ColorEvent(2007);
        COMPOSTER_FILL = new ComposterFillEvent(1500);
        ENDER_DRAGON_FIREBALL_HIT = new OptionalSoundEvent(2006);
    }

    public static class MusicDiscEvent
    extends MetadataEvent {
        private MusicDiscEvent(int id) {
            super(id);
        }

        public void stop(Level level, @Nullable Player player, BlockPos pos) {
            this.play(level, player, pos, null);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos, @Nullable Item musicDisc) {
            this.play(level, player, pos, musicDisc instanceof RecordItem ? Item.m_41393_((Item)musicDisc) : 0);
        }
    }

    public static class DispenserSmokeEvent
    extends MetadataEvent {
        private DispenserSmokeEvent(int id) {
            super(id);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos, Direction direction) {
            this.play(level, player, pos, direction.m_122411_());
        }
    }

    public static class BoneMealEvent
    extends MetadataEvent {
        private BoneMealEvent(int id) {
            super(id);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos) {
            this.play(level, player, pos, 0);
        }

        @Override
        public void play(Level level, @Nullable Player player, BlockPos pos, int particleCount) {
            super.play(level, player, pos, particleCount);
        }
    }

    public static class BlockBreakEvent
    extends MetadataEvent {
        private BlockBreakEvent(int id) {
            super(id);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos, BlockState blockState) {
            this.play(level, player, pos, Block.m_49956_((BlockState)blockState));
        }
    }

    public static class ColorEvent
    extends MetadataEvent {
        private ColorEvent(int id) {
            super(id);
        }

        public void playRGBFloats(Level level, @Nullable Player player, BlockPos pos, float r, float g, float b) {
            this.playRGB(level, player, pos, CrustMath.toRGB(r, g, b));
        }

        public void playRGB(Level level, @Nullable Player player, BlockPos pos, int r, int g, int b) {
            this.playRGB(level, player, pos, CrustMath.bitsToRGB(r, g, b));
        }

        public void playRGB(Level level, @Nullable Player player, BlockPos pos, int rgb) {
            this.play(level, player, pos, rgb);
        }
    }

    public static class ComposterFillEvent
    extends MetadataEvent {
        private ComposterFillEvent(int id) {
            super(id);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos, boolean success) {
            this.play(level, player, pos, success ? 1 : 0);
        }
    }

    public static class OptionalSoundEvent
    extends MetadataEvent {
        private OptionalSoundEvent(int id) {
            super(id);
        }

        public void play(Level level, @Nullable Player player, BlockPos pos, boolean playSound) {
            this.play(level, player, pos, playSound ? 1 : -1);
        }
    }

    public static abstract class MetadataEvent {
        public final int ID;

        private MetadataEvent(int id) {
            this.ID = id;
        }

        protected void play(Level level, @Nullable Player player, BlockPos pos, int metadata) {
            level.m_5898_(player, this.ID, pos, metadata);
        }
    }
}

