/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.datagen.loot;

import fathertoast.crust.api.datagen.loot.LootEntryItemBuilder;
import fathertoast.crust.api.datagen.loot.LootHelper;
import fathertoast.crust.api.datagen.loot.LootPoolBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTableBuilder {
    private final List<LootPool.Builder> pools = new ArrayList<LootPool.Builder>();

    public LootTable.Builder toLootTable() {
        return LootHelper.build(LootTable.m_79147_(), this.pools);
    }

    public LootTableBuilder addPool(LootPool.Builder pool) {
        this.pools.add(pool);
        return this;
    }

    public LootTableBuilder addLootTable(String id, ResourceLocation lootTable) {
        return this.addPool(new LootPoolBuilder(id).addEntryTable(lootTable).toLootPool());
    }

    public LootTableBuilder addGuaranteedDrop(String id, ItemLike item, int count) {
        return this.addPool(new LootPoolBuilder(id).addEntry(new LootEntryItemBuilder(item).setCount(count).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, ItemLike item) {
        return this.addCommonDrop(id, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, ItemStack item) {
        return this.addCommonDrop(id, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, ItemLike item, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry(new LootEntryItemBuilder(item).setCount(0, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, ItemStack item, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry(new LootEntryItemBuilder(item).setCount(0, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, ItemLike item) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootHelper.KILLED_BY_PLAYER_CONDITION).addEntry(new LootEntryItemBuilder(item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, ItemStack item) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootHelper.KILLED_BY_PLAYER_CONDITION).addEntry(new LootEntryItemBuilder(item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, ItemLike item) {
        return this.addClusterDrop(id, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, ItemStack item) {
        return this.addClusterDrop(id, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, ItemLike item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootHelper.UNCOMMON_CONDITIONS).addEntry(new LootEntryItemBuilder(item).setCount(1, max).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, ItemStack item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootHelper.UNCOMMON_CONDITIONS).addEntry(new LootEntryItemBuilder(item).setCount(1, max).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, ItemLike ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootHelper.UNCOMMON_CONDITIONS);
        for (ItemLike item : items) {
            pool.addEntry(new LootEntryItemBuilder(item).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootHelper.UNCOMMON_CONDITIONS);
        for (ItemStack item : items) {
            pool.addEntry(new LootEntryItemBuilder(item).setWeight(item.m_41613_()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, ItemLike ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootHelper.RARE_CONDITIONS);
        for (ItemLike item : items) {
            pool.addEntry(new LootEntryItemBuilder(item).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootHelper.RARE_CONDITIONS);
        for (ItemStack item : items) {
            pool.addEntry(new LootEntryItemBuilder(item).setWeight(item.m_41613_()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }
}

