/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.datagen.loot;

import fathertoast.crust.api.datagen.loot.LootHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootEntryItemBuilder {
    public static final EntityPredicate.Builder ENTITY_ON_FIRE = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
    private final ItemLike ITEM;
    private int weight = 1;
    private int quality = 0;
    private final List<LootItemFunction.Builder> itemFunctions = new ArrayList<LootItemFunction.Builder>();
    private final List<LootItemCondition.Builder> entryConditions = new ArrayList<LootItemCondition.Builder>();

    public LootEntryItemBuilder(ItemLike item) {
        this.ITEM = item;
    }

    public LootEntryItemBuilder(ItemStack itemStack) {
        this((ItemLike)itemStack.m_41720_());
        if (itemStack.m_41783_() != null) {
            this.setNBTTag(itemStack.m_41783_().m_6426_());
        }
    }

    public LootPoolEntryContainer.Builder<?> toLootEntry() {
        return LootHelper.build(LootItem.m_79579_((ItemLike)this.ITEM), this.entryConditions, this.itemFunctions).m_79707_(this.weight).m_79711_(this.quality);
    }

    public LootEntryItemBuilder setWeight(int value) {
        this.weight = value;
        return this;
    }

    public LootEntryItemBuilder setQuality(int value) {
        this.quality = value;
        return this;
    }

    public LootEntryItemBuilder addCondition(LootItemCondition.Builder condition) {
        this.entryConditions.add(condition);
        return this;
    }

    public LootEntryItemBuilder setCount(int value) {
        return this.addFunction((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)value)));
    }

    public LootEntryItemBuilder setCount(int min, int max) {
        return this.addFunction((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootEntryItemBuilder addLootingBonus(float value) {
        return this.addFunction((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)ConstantValue.m_165692_((float)value)));
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max) {
        return this.addFunction((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max, int limit) {
        return this.addFunction((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)).m_80806_(limit));
    }

    public LootEntryItemBuilder setDamage(int value) {
        return this.addFunction((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)ConstantValue.m_165692_((float)value)));
    }

    public LootEntryItemBuilder setDamage(int min, int max) {
        return this.addFunction((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootEntryItemBuilder setNBTTag(CompoundTag tag) {
        return this.addFunction((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag));
    }

    public LootEntryItemBuilder smeltIfBurning() {
        return this.addFunction((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE)));
    }

    public LootEntryItemBuilder applyOneRandomApplicableEnchant() {
        return this.addFunction((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_());
    }

    public LootEntryItemBuilder applyOneRandomEnchant(Enchantment ... enchantments) {
        EnchantRandomlyFunction.Builder builder = new EnchantRandomlyFunction.Builder();
        for (Enchantment enchant : enchantments) {
            builder.m_80444_(enchant);
        }
        return this.addFunction((LootItemFunction.Builder)builder);
    }

    public LootEntryItemBuilder enchant(int level, boolean treasure) {
        EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.m_165196_((NumberProvider)ConstantValue.m_165692_((float)level));
        if (treasure) {
            builder.m_80499_();
        }
        return this.addFunction((LootItemFunction.Builder)builder);
    }

    public LootEntryItemBuilder enchant(int levelMin, int levelMax, boolean treasure) {
        EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)levelMin, (float)levelMax));
        if (treasure) {
            builder.m_80499_();
        }
        return this.addFunction((LootItemFunction.Builder)builder);
    }

    public LootEntryItemBuilder addFunction(LootItemFunction.Builder function) {
        this.itemFunctions.add(function);
        return this;
    }
}

