/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment.biome;

import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.CompareFloatEnvironment;
import fathertoast.crust.api.config.common.value.environment.ComparisonOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class TemperatureEnvironment
extends CompareFloatEnvironment {
    public static final String FREEZING = "freezing";
    public static final float FREEZING_POINT = 0.15f;

    public static String handleTempInput(String line) {
        if (line.equalsIgnoreCase(FREEZING)) {
            return ComparisonOperator.LESS_THAN + " 0.15";
        }
        if (line.equalsIgnoreCase("!freezing")) {
            return ComparisonOperator.LESS_THAN.invert() + " 0.15";
        }
        return line;
    }

    public TemperatureEnvironment(boolean freezing) {
        this(ComparisonOperator.LESS_THAN.invert(!freezing), 0.15f);
    }

    public TemperatureEnvironment(ComparisonOperator op, float value) {
        super(op, value);
    }

    public TemperatureEnvironment(AbstractConfigField field, String line) {
        super(field, TemperatureEnvironment.handleTempInput(line));
    }

    @Override
    public String value() {
        if (this.COMPARATOR == ComparisonOperator.LESS_THAN && this.VALUE == 0.15f) {
            return FREEZING;
        }
        if (this.COMPARATOR == ComparisonOperator.LESS_THAN.invert() && this.VALUE == 0.15f) {
            return "!freezing";
        }
        return super.value();
    }

    @Override
    public float getActual(Level level, @Nullable BlockPos pos) {
        return pos == null ? Float.NaN : ((Biome)level.m_204166_(pos).m_203334_()).m_47505_(pos);
    }
}

