/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public abstract class TagEnvironment<T>
extends AbstractEnvironment {
    protected final boolean INVERT;
    private final TagKey<T> TAG_KEY;

    private static String tagSignFixer(boolean invert, String line) {
        if (invert) {
            return line.substring(line.startsWith("!#") ? 2 : 1);
        }
        if (line.startsWith("#")) {
            return line.substring(1);
        }
        return line;
    }

    public TagEnvironment(TagKey<T> tagKey, boolean invert) {
        this.INVERT = invert;
        this.TAG_KEY = tagKey;
    }

    public TagEnvironment(AbstractConfigField ignoredField, String line) {
        this.INVERT = line.startsWith("!");
        this.TAG_KEY = TagKey.m_203882_(this.getRegistry(), (ResourceLocation)ResourceLocation.parse((String)TagEnvironment.tagSignFixer(this.INVERT, line)));
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!#" : "#") + this.TAG_KEY.f_203868_();
    }

    public abstract ResourceKey<Registry<T>> getRegistry();

    @Override
    public boolean matches(Level level, @Nullable BlockPos pos) {
        Holder<T> actual = this.getActual(level, pos);
        return (actual != null && actual.m_203656_(this.TAG_KEY)) != this.INVERT;
    }

    @Nullable
    public abstract Holder<T> getActual(Level var1, @Nullable BlockPos var2);
}

